/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.tile.EnhancedSkullBlockTile;
import net.mehvahdjukaar.amendments.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.CompatObjects;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CandleSkullBlockTile
extends EnhancedSkullBlockTile {
    private BlockState candle = Blocks.AIR.defaultBlockState();
    private ResourceLocation waxTexture = null;
    private ParticleType<?> particle = ParticleTypes.SMALL_FLAME;

    public CandleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModRegistry.SKULL_CANDLE_TILE.get(), pWorldPosition, pBlockState);
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Candle", (Tag)NbtUtils.writeBlockState((BlockState)this.candle));
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        BlockState c = null;
        if (tag.contains("Candle", 10)) {
            c = Utils.readBlockState((CompoundTag)tag.getCompound("Candle"), (Level)this.level);
        }
        this.setCandle(c);
    }

    public BlockState getCandle() {
        return this.candle;
    }

    public void setCandle(BlockState candle) {
        this.candle = candle;
        if (PlatHelper.getPhysicalSide().isClient()) {
            Block b;
            this.waxTexture = null;
            if (this.candle != null) {
                this.waxTexture = AmendmentsClient.SKULL_CANDLES_TEXTURES.get().get(this.candle.getBlock());
            }
            this.particle = (b = candle.getBlock()) == CompatObjects.CUPRIC_CANDLE.get() ? CompatObjects.SMALL_CUPRIC_FLAME.get() : (b == CompatObjects.ENDER_CANDLE.get() ? CompatObjects.SMALL_ENDER_FLAME.get() : (b == CompatObjects.SOUL_CANDLE.get() ? CompatObjects.SMALL_SOUL_FLAME.get() : ParticleTypes.SMALL_FLAME));
        }
    }

    public boolean tryAddingCandle(CandleBlock candle) {
        if (this.candle.isAir() || candle == this.candle.getBlock() && (Integer)this.candle.getValue((Property)CandleBlock.CANDLES) != 4) {
            if (this.candle.isAir()) {
                this.setCandle(candle.defaultBlockState());
            } else {
                this.candle.cycle((Property)CandleBlock.CANDLES);
            }
            if (!this.level.isClientSide) {
                BlockState state = this.getBlockState();
                BlockState newState = Utils.replaceProperty((BlockState)this.candle, (BlockState)state, (Property)CandleBlock.CANDLES);
                this.level.setBlockAndUpdate(this.worldPosition, newState);
                this.setChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, ItemStack stack, Player player, InteractionHand hand) {
        BlockItem blockItem;
        super.initialize(oldTile, stack, player, hand);
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CandleBlock) {
            CandleBlock candleBlock = (CandleBlock)item;
            this.tryAddingCandle(candleBlock);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CandleSkullBlockTile e) {
        e.tick(level, pos, state);
        if (CompatHandler.CAVE_ENHANCEMENTS && e.candle.is(CompatObjects.SPECTACLE_CANDLE.get())) {
            CaveEnhancementsCompat.tick(level, pos, state);
        }
    }

    public ParticleType<?> getParticle() {
        return this.particle;
    }
}

