/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.client.screen.element.button.AutoEjectButton;
import edivad.dimstorage.client.screen.pattern.FrequencyScreen;
import edivad.dimstorage.menu.DimTankMenu;
import edivad.edivadlib.tools.utils.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class ScreenDimTank
extends FrequencyScreen<DimTankMenu> {
    private static final ResourceLocation DIMTANK_GUI = DimStorage.rl("textures/gui/dimtank.png");

    public ScreenDimTank(DimTankMenu container, Inventory inventory, Component text) {
        super(container, container.owner, inventory, text, DIMTANK_GUI, container.isOpen);
    }

    private static int getFluidScaled(int pixels, int currentLiquidAmount) {
        int maxLiquidAmount = 16000;
        int x = currentLiquidAmount * pixels / maxLiquidAmount;
        return pixels - x;
    }

    @Override
    protected void init() {
        super.init();
        this.addComponent((AbstractWidget)new AutoEjectButton(this.width / 2 + 95, this.height / 2 + 75, (BlockEntityDimTank)this.blockEntityFrequencyOwner));
        this.drawSettings(this.drawSettings);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        FluidStack liquidStack = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        if (!liquidStack.isEmpty()) {
            FluidType fluidType = liquidStack.getFluid().getFluidType();
            String liquidName = liquidStack.getHoverName().getString();
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.dimstorage.liquid", (Object[])new Object[]{liquidName.substring(0, Math.min(14, liquidName.length()))}), 50, 25, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.dimstorage.amount", (Object[])new Object[]{liquidStack.getAmount()}), 50, 35, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.dimstorage.temperature", (Object[])new Object[]{fluidType.getTemperature() - 273}), 50, 45, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.dimstorage.luminosity", (Object[])new Object[]{fluidType.getLightLevel()}), 50, 55, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.dimstorage.gas").append(" ").append((Component)(fluidType.isLighterThanAir() ? Component.translatable((String)"gui.dimstorage.yes") : Component.translatable((String)"gui.dimstorage.no"))), 50, 65, 0x404040, false);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.dimstorage.liquid", (Object[])new Object[]{Component.translatable((String)"gui.dimstorage.empty")}), 50, 25, 0x404040, false);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        FluidStack fluid = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        int z = ScreenDimTank.getFluidScaled(60, fluid.getAmount());
        if (!fluid.isEmpty()) {
            TextureAtlasSprite fluidTexture = FluidUtils.getFluidTexture((FluidStack)fluid);
            if (fluidTexture == null) {
                return;
            }
            int color = FluidUtils.getLiquidColorWithBiome((FluidStack)fluid, (BlockEntity)this.blockEntityFrequencyOwner);
            float red = FluidUtils.getRed((int)color);
            float green = FluidUtils.getGreen((int)color);
            float blue = FluidUtils.getBlue((int)color);
            float alpha = FluidUtils.getAlpha((int)color);
            guiGraphics.blit(this.leftPos + 11, this.topPos + 21 + z, 176, 16, 60 - z, fluidTexture, red, green, blue, alpha);
        }
    }
}

