/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.compat.top.MyFluidElement;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerElementFactory(new IElementFactory(this){

            public IElement createElement(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                return new MyFluidElement(registryFriendlyByteBuf);
            }

            public ResourceLocation getId() {
                return MyFluidElement.ID;
            }
        });
        return null;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState state, IProbeHitData data) {
        BlockEntity blockEntity = level.getBlockEntity(data.getPos());
        if (blockEntity instanceof BlockEntityFrequencyOwner) {
            BlockEntity blockEntity2;
            BlockEntityFrequencyOwner frequencyOwner = (BlockEntityFrequencyOwner)blockEntity;
            MutableComponent locked = Component.translatable((String)"gui.dimstorage.locked");
            MutableComponent yes = Component.translatable((String)"gui.dimstorage.yes");
            MutableComponent eject = Component.translatable((String)"gui.dimstorage.eject");
            MutableComponent owner = Component.translatable((String)"gui.dimstorage.owner");
            MutableComponent frequency = Component.translatable((String)"gui.dimstorage.frequency");
            Frequency blockFrequency = frequencyOwner.getFrequency();
            if (blockFrequency.hasOwner()) {
                ChatFormatting textColor = frequencyOwner.canAccess(player) ? ChatFormatting.GREEN : ChatFormatting.RED;
                probeInfo.horizontal().text((Component)owner.append(" " + blockFrequency.getOwner()).withStyle(textColor));
            }
            probeInfo.horizontal().text((Component)frequency.append(" " + blockFrequency.channel()));
            if (frequencyOwner.locked) {
                probeInfo.horizontal().text((Component)locked.append(" ").append((Component)yes));
            }
            if ((blockEntity2 = level.getBlockEntity(data.getPos())) instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)blockEntity2;
                if (tank.autoEject) {
                    probeInfo.horizontal().text((Component)eject.append(" ").append((Component)yes));
                }
                if (!tank.liquidState.serverLiquid.isEmpty()) {
                    probeInfo.element((IElement)new MyFluidElement(tank, 16000));
                }
            }
        }
    }

    public ResourceLocation getID() {
        return DimStorage.rl("default");
    }
}

