/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Inventory;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageContainerMenu;

public class MovingStorageScreen
extends StorageScreenBase<MovingStorageContainerMenu<?>> {
    public static final int HORSE_VIEW_PADDING = 7;
    public static final int HORSE_VIEW_SIZE = 52;
    public static final int HORSE_WIDGET_WIDTH = 88;
    private static final ResourceLocation SADDLE_SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/horse/saddle_slot");
    private static final ResourceLocation LLAMA_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/horse/llama_armor_slot");

    public static MovingStorageScreen constructScreen(MovingStorageContainerMenu<?> screenContainer, Inventory inv, Component title) {
        return new MovingStorageScreen(screenContainer, inv, title);
    }

    protected MovingStorageScreen(MovingStorageContainerMenu menu, Inventory playerInventory, Component title) {
        super((StorageContainerMenuBase)menu, playerInventory, title);
    }

    protected String getStorageSettingsTabTooltip() {
        return StorageTranslationHelper.INSTANCE.translGui("settings.tooltip");
    }

    protected void updateExtraSlotsPositions() {
        super.updateExtraSlotsPositions();
        ((MovingStorageContainerMenu)this.getMenu()).getStorageEntity().ifPresent(entity -> {
            if (entity instanceof AbstractChestedHorse) {
                ((MovingStorageContainerMenu)this.getMenu()).getExtraSlots().forEach(slot -> {
                    if (slot.isActive()) {
                        slot.x = this.inventoryLabelX - 90;
                        slot.y = this.inventoryLabelY + 70;
                    }
                });
            }
        });
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        ((MovingStorageContainerMenu)this.getMenu()).getStorageEntity().ifPresent(entity -> {
            if (entity instanceof AbstractChestedHorse) {
                AbstractChestedHorse horse = (AbstractChestedHorse)entity;
                int y = this.getHorseControlY();
                int x = this.getHorseControlX();
                int horseWidgetHeight = 66;
                int slotX = x + 7;
                int slotY = y + horseWidgetHeight - 7 - 18;
                GuiHelper.renderControlBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)88, (int)horseWidgetHeight, (int)128, (int)0, (int)128, (int)256);
                if (horse.isSaddleable()) {
                    guiGraphics.blitSprite(SADDLE_SLOT_SPRITE, slotX, slotY, 18, 18);
                }
                if (horse.canUseSlot(EquipmentSlot.BODY) && horse instanceof Llama) {
                    guiGraphics.blitSprite(LLAMA_ARMOR_SLOT_SPRITE, slotX, slotY, 18, 18);
                }
                int entityViewX = x + 88 - 7 - 52;
                int entityViewY = y + 7;
                guiGraphics.fill(entityViewX, entityViewY, entityViewX + 52, entityViewY + 52, -16777216);
                InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)entityViewX, (int)entityViewY, (int)(entityViewX + 52), (int)(entityViewY + 52), (int)17, (float)0.25f, (float)mouseX, (float)mouseY, (LivingEntity)horse);
            }
        });
    }

    private int getHorseControlY() {
        return this.getTopY() + this.inventoryLabelY + 28;
    }

    private int getHorseControlX() {
        return this.getLeftX() + this.inventoryLabelX - 88 - 10;
    }

    public Rect2i getHorseControlRectangle() {
        return new Rect2i(this.getHorseControlX(), this.getHorseControlY(), 128, 256);
    }
}

