/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockEntangledChalice;
import org.cyclops.evilcraft.client.render.blockentity.RenderItemStackBlockEntityEntangledChalice;
import org.cyclops.evilcraft.item.ItemEntangledChalice;

public class BlockEntangledChaliceConfig
extends BlockConfig {
    @ConfigurableProperty(category="machine", comment="If the fluid should be rendered statically. Fluids won't be shown fluently, but more efficiently.", requiresMcRestart=true)
    public static boolean staticBlockRendering = false;

    public BlockEntangledChaliceConfig() {
        super((ModBase)EvilCraft._instance, "entangled_chalice", eConfig -> new BlockEntangledChalice(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.5f).sound(SoundType.STONE)), (eConfig, block) -> new ItemEntangledChalice((Block)block, new Item.Properties()){

            @OnlyIn(value=Dist.CLIENT)
            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new RenderItemStackBlockEntityEntangledChalice.ItemRenderProperties());
            }
        });
        EvilCraft._instance.getModEventBus().addListener(this::registerCapability);
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    protected void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new ItemEntangledChalice.FluidHandler((ItemStack)stack, 4000), new ItemLike[]{(ItemLike)this.getInstance()});
    }

    protected Collection<ItemStack> defaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        ((BlockEntangledChalice)this.getInstance()).fillItemCategory((NonNullList<ItemStack>)list);
        return list;
    }
}

