/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockUndeadWoodStrippedConfig
extends BlockConfig {
    public BlockUndeadWoodStrippedConfig() {
        super((ModBase)EvilCraft._instance, "undead_wood_stripped", eConfig -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(2.0f, 3.0f).sound(SoundType.WOOD)){

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }
        }, BlockUndeadWoodStrippedConfig.getDefaultItemConstructor((ModBase)EvilCraft._instance));
        NeoForge.EVENT_BUS.addListener(this::toolActionEvent);
    }

    public void toolActionEvent(BlockEvent.BlockToolModificationEvent event) {
        if (event.getItemAbility() == ItemAbilities.AXE_STRIP && event.getState().getBlock() == RegistryEntries.BLOCK_UNDEAD_WOOD.get()) {
            BlockState blockStateNew = ((Block)RegistryEntries.BLOCK_UNDEAD_WOOD_STRIPPED.get()).defaultBlockState();
            for (Property property : event.getState().getProperties()) {
                if (!blockStateNew.hasProperty(property)) continue;
                blockStateNew = (BlockState)blockStateNew.setValue(property, event.getState().getValue(property));
            }
            event.setFinalState(blockStateNew);
        }
    }
}

