/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;

public abstract class BloodInfuserTickAction
implements ITickAction<BlockEntityBloodInfuser> {
    protected static final int MB_PER_TICK = 100;

    @Override
    public boolean canTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.getTank().isEmpty() && this.getInfuseStack(tile) != null && tile.getTileWorkingMetadata().canConsume(this.getInfuseStack(tile), tile.getLevel())) {
            ItemStack production = tile.getInventory().getItem(tile.getTileWorkingMetadata().getProduceSlot());
            ItemStack willProduce = this.willProduceItem(tile);
            if (production.isEmpty()) {
                return true;
            }
            if (!willProduce.isEmpty() && production.getItem() == this.willProduceItem(tile).getItem() && production.getCount() + willProduce.getCount() <= production.getMaxStackSize()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack getInfuseStack(BlockEntityBloodInfuser tile) {
        return tile.getInventory().getItem(tile.getTileWorkingMetadata().getConsumeSlot());
    }

    public abstract ItemStack willProduceItem(BlockEntityBloodInfuser var1);

    public boolean addToProduceSlot(BlockEntityBloodInfuser tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot((Container)tile.getInventory(), (int)tile.getTileWorkingMetadata().getProduceSlot(), (ItemStack)itemStack);
    }

    public abstract int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser var1, int var2);

    @Override
    public final float getRequiredTicks(BlockEntityBloodInfuser tile, int slot, int tick) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, slot));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntityBloodInfuser.UPGRADEEVENT_SPEED));
        return duration.getValue().intValue();
    }
}

