/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.network.packet.UpdateWorldSharedTankClientCachePacket;

public class WorldSharedTankCache {
    public static final int INTERPOLATION_TICK_OFFSET = 10;
    private static WorldSharedTankCache _instance = null;
    private Map<String, FluidStack> tankCache = Maps.newHashMap();
    private Map<String, UpdateWorldSharedTankClientCachePacket> packetBuffer = Maps.newHashMap();
    private int tick = 0;

    private WorldSharedTankCache() {
    }

    public void reset() {
        this.tankCache = Maps.newHashMap();
        this.packetBuffer = Maps.newHashMap();
        this.tick = 0;
    }

    public static WorldSharedTankCache getInstance() {
        if (_instance == null) {
            _instance = new WorldSharedTankCache();
        }
        return _instance;
    }

    protected String getMapID(String tankID) {
        return tankID + (MinecraftHelpers.isClientSide() ? "C" : "S");
    }

    protected String removeMapID(String mapID) {
        return mapID.substring(0, mapID.length() - 1);
    }

    public synchronized FluidStack getTankContent(String tankID) {
        FluidStack stack = this.tankCache.get(this.getMapID(tankID));
        return stack == null ? FluidStack.EMPTY : stack.copy();
    }

    protected static boolean shouldRefreshFluid(@Nullable FluidStack old, FluidStack newF) {
        return (old == null ? 0 : old.getAmount()) != newF.getAmount();
    }

    public synchronized void setTankContent(String tankID, FluidStack fluidStack) {
        String key = this.getMapID(tankID);
        boolean shouldRefresh = WorldSharedTankCache.shouldRefreshFluid(this.tankCache.get(key), fluidStack);
        if (fluidStack.isEmpty()) {
            this.tankCache.remove(key);
        } else if (shouldRefresh) {
            this.tankCache.put(key, fluidStack.copy());
        }
        if (!MinecraftHelpers.isClientSide() && shouldRefresh) {
            this.bufferPacket(tankID, new UpdateWorldSharedTankClientCachePacket(tankID, fluidStack));
        }
    }

    protected void bufferPacket(String tankID, UpdateWorldSharedTankClientCachePacket packet) {
        this.packetBuffer.put(tankID, packet);
    }

    public int getTickOffset() {
        return this.tick;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onTickServer(ServerTickEvent.Pre event) {
        this.onTick(event);
    }

    public void onTick(ServerTickEvent.Pre event) {
        ++this.tick;
        if (this.getTickOffset() > 10) {
            Iterator<Map.Entry<String, UpdateWorldSharedTankClientCachePacket>> it = this.packetBuffer.entrySet().iterator();
            while (it.hasNext()) {
                EvilCraft._instance.getPacketHandler().sendToAll((PacketBase)it.next().getValue());
                it.remove();
            }
            this.tick = 0;
        }
    }

    @SubscribeEvent
    public void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!MinecraftHelpers.isClientSide()) {
            for (Map.Entry<String, FluidStack> entry : this.tankCache.entrySet()) {
                EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateWorldSharedTankClientCachePacket(this.removeMapID(entry.getKey()), entry.getValue()), (ServerPlayer)event.getEntity());
            }
        }
    }

    public void readFromNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        if (tag != null) {
            ListTag list = tag.getList("tankCache", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag subTag = list.getCompound(i);
                this.setTankContent(subTag.getString("key"), (FluidStack)((Pair)FluidStack.CODEC.decode((DynamicOps)holderLookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)subTag.getCompound("value")).getOrThrow()).getFirst());
            }
        }
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        ListTag list = new ListTag();
        for (Map.Entry<String, FluidStack> entry : this.tankCache.entrySet()) {
            CompoundTag subTag = new CompoundTag();
            subTag.putString("key", this.removeMapID(entry.getKey()));
            Tag fluidTag = (Tag)FluidStack.CODEC.encodeStart((DynamicOps)holderLookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)entry.getValue()).getOrThrow();
            subTag.put("value", fluidTag);
            list.add((Object)subTag);
        }
        tag.put("tankCache", (Tag)list);
    }
}

