/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment.entityeffect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.item.ItemVengeanceRing;

public record EnchantmentEntityEffectSummonVengeanceSpirit(int area, int chance) implements EnchantmentEntityEffect
{
    public static final MapCodec<EnchantmentEntityEffectSummonVengeanceSpirit> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("area").forGetter(EnchantmentEntityEffectSummonVengeanceSpirit::area), (App)Codec.INT.fieldOf("chance").forGetter(EnchantmentEntityEffectSummonVengeanceSpirit::chance)).apply((Applicative)builder, EnchantmentEntityEffectSummonVengeanceSpirit::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 vec) {
        int chance;
        if (enchantmentLevel > 0 && (chance = Math.max(1, this.chance() / enchantmentLevel)) > 0 && level.random.nextInt(chance) == 0) {
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                entity = projectile.getEffectSource();
            }
            ItemVengeanceRing.toggleVengeanceArea((Level)level, entity, this.area * enchantmentLevel, true, true, true);
        }
    }

    public MapCodec<EnchantmentEntityEffectSummonVengeanceSpirit> codec() {
        return CODEC;
    }
}

