/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;

public class SanguinaryPedestalBlockReplacePacket
extends PacketCodec<SanguinaryPedestalBlockReplacePacket> {
    public static final CustomPacketPayload.Type<SanguinaryPedestalBlockReplacePacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"sanguinary_pedestal_block_replace"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SanguinaryPedestalBlockReplacePacket> CODEC = SanguinaryPedestalBlockReplacePacket.getCodec(SanguinaryPedestalBlockReplacePacket::new);
    public static final int RANGE = 15;
    @CodecField
    private double x = 0.0;
    @CodecField
    private double y = 0.0;
    @CodecField
    private double z = 0.0;

    public SanguinaryPedestalBlockReplacePacket() {
        super(ID);
    }

    public boolean isAsync() {
        return false;
    }

    public SanguinaryPedestalBlockReplacePacket(double x, double y, double z) {
        super(ID);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        world.playLocalSound(this.x, this.y, this.z, ((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState().getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.1f + world.random.nextFloat() * 0.5f, 0.9f + world.random.nextFloat() * 0.1f, false);
        ParticleBloodSplash.spawnParticles(world, new BlockPos((int)this.x, (int)this.y + 1, (int)this.z), 3 + world.random.nextInt(2), 1 + world.random.nextInt(2));
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

