/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ForceFieldBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    protected static final VoxelShape BASE_SHAPE = Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    protected static final VoxelShape UP_SHAPE = Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape DOWN_WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0);
    protected static final VoxelShape DOWN_EAST_SHAPE = Block.box((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)7.0, (double)9.0);
    protected static final VoxelShape DOWN_NORTH_SHAPE = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0);
    protected static final VoxelShape DOWN_SOUTH_SHAPE = Block.box((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0, (double)16.0);
    protected static final VoxelShape UP_WEST_SHAPE = Block.box((double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0);
    protected static final VoxelShape UP_EAST_SHAPE = Block.box((double)9.0, (double)9.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape UP_NORTH_SHAPE = Block.box((double)7.0, (double)9.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
    protected static final VoxelShape UP_SOUTH_SHAPE = Block.box((double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_WEST_SHAPE = Block.box((double)0.0, (double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0);
    protected static final VoxelShape NORTH_EAST_SHAPE = Block.box((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SOUTH_WEST_SHAPE = Block.box((double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SOUTH_EAST_SHAPE = Block.box((double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ForceFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean cornerConnects(BlockGetter getter, BlockPos pos, Direction dir1, Direction dir2) {
        Vec3i vec31 = dir1.getNormal();
        Vec3i vec32 = dir2.getNormal();
        return ForceFieldBlock.fullFaceOrSimilarForceField(getter, pos.offset(vec31), dir1, dir2) || ForceFieldBlock.fullFaceOrSimilarForceField(getter, pos.offset(vec32), dir2, dir1);
    }

    private static boolean fullFaceOrSimilarForceField(BlockGetter getter, BlockPos pos, Direction relative, Direction similar) {
        BlockState state = getter.getBlockState(pos);
        return state.isFaceSturdy(getter, pos, relative.getOpposite()) || state.getBlock() instanceof ForceFieldBlock && (Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(similar)) != false;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = BASE_SHAPE;
        boolean down = (Boolean)state.getValue((Property)DOWN);
        boolean up = (Boolean)state.getValue((Property)UP);
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean east = (Boolean)state.getValue((Property)EAST);
        if (down) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
            if (north && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.NORTH)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_NORTH_SHAPE);
            }
            if (south && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.SOUTH)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_SOUTH_SHAPE);
            }
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.WEST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.EAST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_EAST_SHAPE);
            }
        }
        if (up) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_SHAPE);
            if (north && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.NORTH)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_NORTH_SHAPE);
            }
            if (south && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.SOUTH)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_SOUTH_SHAPE);
            }
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.WEST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.EAST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_EAST_SHAPE);
            }
        }
        if (north) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.NORTH, Direction.WEST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.NORTH, Direction.EAST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_EAST_SHAPE);
            }
        }
        if (south) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.SOUTH, Direction.WEST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.SOUTH, Direction.EAST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_EAST_SHAPE);
            }
        }
        if (west) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (east) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public boolean canConnectTo(@Nullable BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState relative = getter.getBlockState(pos.relative(direction));
        if (relative.is((Block)this)) {
            return true;
        }
        int betterConnections = 0;
        if (state == null) {
            for (Direction face : Direction.values()) {
                if (!getter.getBlockState(pos.relative(face)).is((Block)this)) continue;
                ++betterConnections;
            }
        } else {
            for (Direction face : Direction.values()) {
                if (!((Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(face))).booleanValue()) continue;
                ++betterConnections;
            }
        }
        if (betterConnections >= 3) {
            return false;
        }
        return !ForceFieldBlock.isExceptionForConnection((BlockState)relative) && relative.isFaceSturdy(getter, pos.relative(direction), direction.getOpposite());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Direction clicked = context.getClickedFace();
        BlockState state = this.defaultBlockState();
        for (Direction dir : Direction.values()) {
            state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(clicked.getOpposite() == dir || (clicked != dir ? this.canConnectTo(null, (BlockGetter)level, pos, dir) : !context.isSecondaryUseActive())));
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor accessor, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return this.canConnectTo(state, (BlockGetter)accessor, pos, direction) ? (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true)) : state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            default -> state;
        };
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> state;
        };
    }
}

