/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.TFPlantBlock;

public class RootStrandBlock
extends TFPlantBlock
implements BonemealableBlock {
    public static final MapCodec<RootStrandBlock> CODEC = RootStrandBlock.simpleCodec(RootStrandBlock::new);
    private static final VoxelShape ROOT_SHAPE = RootStrandBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public RootStrandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return TFPlantBlock.canPlaceRootAt((BlockGetter)reader, pos) || reader.getBlockState(pos.above()).is((Block)this);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return ROOT_SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader getter, BlockPos pos, BlockState state) {
        return this.isBottomOpen((BlockGetter)getter, pos);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return this.isBottomOpen((BlockGetter)level, pos);
    }

    private boolean isBottomOpen(BlockGetter getter, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            mutable.move(Direction.DOWN);
        } while (getter.getBlockState((BlockPos)mutable).is((Block)this));
        return getter.getBlockState((BlockPos)mutable).isAir() || getter.getBlockState((BlockPos)mutable).canBeReplaced();
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            mutable.move(Direction.DOWN);
        } while (level.getBlockState((BlockPos)mutable).is((Block)this));
        if (level.getBlockState((BlockPos)mutable).isAir() || level.getBlockState((BlockPos)mutable).canBeReplaced()) {
            level.setBlockAndUpdate((BlockPos)mutable, this.defaultBlockState());
        }
    }
}

