/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.TriState;
import twilightforest.block.MushgloomBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;

public class UberousSoilBlock
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public UberousSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos().above());
        return state.isSolid() && (!(state.getBlock() instanceof BonemealableBlock) || state.is((Block)this)) ? Blocks.DIRT.defaultBlockState() : super.getStateForPlacement(ctx);
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        if (facing.getAxis() != Direction.Axis.Y) {
            return TriState.FALSE;
        }
        if (plant.is(BlockTags.CROPS)) {
            return TriState.TRUE;
        }
        return super.canSustainPlant(state, level, soilPosition, facing, plant);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!newState.is(state.getBlock()) && !level.getBlockState(pos.above()).isAir()) {
            this.neighborChanged(state, level, pos, this, pos.above(), moving);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        block20: {
            block17: {
                ServerLevel serverLevel;
                BonemealableBlock bonemealableBlock;
                BlockState above;
                block19: {
                    block18: {
                        if (fromPos.getY() != pos.getY() + 1) break block17;
                        above = level.getBlockState(fromPos);
                        Block block2 = above.getBlock();
                        if (!(block2 instanceof BonemealableBlock)) break block18;
                        bonemealableBlock = (BonemealableBlock)block2;
                        if (!above.is((Block)this)) break block19;
                    }
                    if (above.isSolid()) {
                        FarmBlock.turnToDirt(null, (BlockState)state, (Level)level, (BlockPos)pos);
                    }
                    return;
                }
                BlockState newState = Blocks.DIRT.defaultBlockState();
                if (above.is(BlockTags.CROPS)) {
                    newState = (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7));
                } else if (bonemealableBlock instanceof MushroomBlock) {
                    newState = Blocks.MYCELIUM.defaultBlockState();
                } else if (bonemealableBlock instanceof BushBlock) {
                    newState = Blocks.GRASS_BLOCK.defaultBlockState();
                } else if (bonemealableBlock instanceof MossBlock) {
                    MossBlock mossBlock = (MossBlock)bonemealableBlock;
                    newState = mossBlock.defaultBlockState();
                }
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    if (bonemealableBlock instanceof MushgloomBlock) {
                        MushgloomBlock mushgloomBlock = (MushgloomBlock)bonemealableBlock;
                        level.setBlockAndUpdate(pos, UberousSoilBlock.pushEntitiesUp((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos));
                        mushgloomBlock.growMushroom(serverLevel, fromPos, above, serverLevel.random);
                        level.levelEvent(2005, fromPos, 0);
                        return;
                    }
                    level.levelEvent(1505, fromPos, 15);
                }
                level.setBlockAndUpdate(pos, UberousSoilBlock.pushEntitiesUp((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos));
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    MinecraftServer server = serverLevel.getServer();
                    FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
                    server.tell((Runnable)new TickTask(server.getTickCount(), () -> {
                        for (int i = 0; i < 15; ++i) {
                            BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)serverLevel, (BlockPos)fromPos, (Player)fakePlayer);
                        }
                    }));
                }
                level.levelEvent(2005, fromPos, 0);
                break block20;
            }
            if (fromPos.getY() + 1 == pos.getY()) {
                BlockState below = level.getBlockState(fromPos);
                if (!(below.getBlock() instanceof BonemealableBlock)) {
                    return;
                }
                level.setBlockAndUpdate(pos, UberousSoilBlock.pushEntitiesUp((BlockState)state, (BlockState)Blocks.DIRT.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    MinecraftServer server = serverLevel.getServer();
                    FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
                    server.tell((Runnable)new TickTask(server.getTickCount(), () -> {
                        for (int i = 0; i < 15; ++i) {
                            BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)serverLevel, (BlockPos)fromPos, (Player)fakePlayer);
                        }
                    }));
                    level.levelEvent(1505, fromPos, 15);
                }
                level.levelEvent(2005, fromPos, 0);
            }
        }
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (level.isClientSide() && rand.nextInt(5) == 0 && Minecraft.getInstance().player != null && Minecraft.getInstance().player.isHolding((Item)TFItems.MAGIC_BEANS.get())) {
            for (int i = 0; i < 2; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 1.25, (double)pos.getZ() + rand.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader getter, BlockPos pos, BlockState state) {
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP || dir == Direction.DOWN) continue;
            BlockState blockAt = getter.getBlockState(pos.relative(dir));
            if (!getter.getBlockState(pos.relative(dir).above()).isSolid() && (blockAt.is(BlockTags.DIRT) || blockAt.is(Blocks.FARMLAND)) && !blockAt.is(TFBlocks.UBEROUS_SOIL)) {
                return true;
            }
            if (!getter.getBlockState(pos.relative(dir).above().above()).isSolid() && (getter.getBlockState(pos.relative(dir).above()).is(BlockTags.DIRT) || getter.getBlockState(pos.relative(dir).above()).is(Blocks.FARMLAND)) && !getter.getBlockState(pos.relative(dir).above()).is(TFBlocks.UBEROUS_SOIL)) {
                return true;
            }
            if (getter.getBlockState(pos.relative(dir)).isSolid() || !getter.getBlockState(pos.relative(dir).below()).is(BlockTags.DIRT) && !getter.getBlockState(pos.relative(dir).below()).is(Blocks.FARMLAND) || getter.getBlockState(pos.relative(dir).below()).is(TFBlocks.UBEROUS_SOIL)) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        List<Direction> directions = Arrays.asList(Direction.values());
        Collections.shuffle(directions);
        for (Direction dir : directions) {
            if (dir == Direction.UP || dir == Direction.DOWN) continue;
            BlockState blockAt = level.getBlockState(pos.relative(dir));
            if (!level.getBlockState(pos.relative(dir).above()).isSolid() && (blockAt.is(BlockTags.DIRT) || blockAt.is(Blocks.FARMLAND)) && !blockAt.is(TFBlocks.UBEROUS_SOIL)) {
                this.spreadTo(level, pos.relative(dir));
                break;
            }
            if (!level.getBlockState(pos.relative(dir).above().above()).isSolid() && (level.getBlockState(pos.relative(dir).above()).is(BlockTags.DIRT) || level.getBlockState(pos.relative(dir).above()).is(Blocks.FARMLAND)) && !level.getBlockState(pos.relative(dir).above()).is(TFBlocks.UBEROUS_SOIL)) {
                this.spreadTo(level, pos.relative(dir).above());
                break;
            }
            if (level.getBlockState(pos.relative(dir)).isSolid() || !level.getBlockState(pos.relative(dir).below()).is(BlockTags.DIRT) && !level.getBlockState(pos.relative(dir).below()).is(Blocks.FARMLAND) || level.getBlockState(pos.relative(dir).below()).is(TFBlocks.UBEROUS_SOIL)) continue;
            this.spreadTo(level, pos.relative(dir).below());
            break;
        }
    }

    public void spreadTo(ServerLevel level, BlockPos pos) {
        level.setBlockAndUpdate(pos, this.defaultBlockState());
        if (!level.getBlockState(pos.above()).isAir()) {
            this.neighborChanged(this.defaultBlockState(), (Level)level, pos, this, pos.above(), false);
        }
    }
}

