/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public interface WaterloggedBlock
extends BucketPickup,
LiquidBlockContainer {
    public boolean isStateWaterlogged(BlockState var1);

    public BlockState setWaterlog(BlockState var1, boolean var2);

    default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid) {
        return !this.isStateWaterlogged(state) && fluid == Fluids.WATER;
    }

    default public boolean placeLiquid(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!this.isStateWaterlogged(state) && fluidState.getType() == Fluids.WATER) {
            if (!accessor.isClientSide()) {
                accessor.setBlock(pos, this.setWaterlog(state, true), 3);
                accessor.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)accessor));
            }
            return true;
        }
        return false;
    }

    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor accessor, BlockPos pos, BlockState state) {
        if (this.isStateWaterlogged(state)) {
            accessor.setBlock(pos, this.setWaterlog(state, false), 3);
            if (!state.canSurvive((LevelReader)accessor, pos)) {
                accessor.destroyBlock(pos, true);
            }
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    default public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

