/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity.bookshelf;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.ChiseledCanopyShelfBlock;
import twilightforest.block.entity.bookshelf.ChiseledCanopyShelfBlockEntity;

public abstract class BookshelfSpawner
implements IOwnedSpawner {
    public static final List<Pair<Integer, BooleanProperty>> SLOT_PROPERTIES_AND_INDEXES = List.of(Pair.of((Object)0, (Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_0_OCCUPIED), Pair.of((Object)1, (Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_1_OCCUPIED), Pair.of((Object)2, (Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_2_OCCUPIED), Pair.of((Object)3, (Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_3_OCCUPIED), Pair.of((Object)4, (Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_4_OCCUPIED), Pair.of((Object)5, (Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_5_OCCUPIED));
    public int maxNearbyEntities = 4;
    public int spawnRange = 4;
    public int spawnCheckRange = 12;
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    private SpawnData nextSpawnData;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 400;
    private int requiredPlayerRange = 8;
    private final PlayerDetector detector = PlayerDetector.INCLUDING_CREATIVE_PLAYERS;

    public void setEntityId(EntityType<?> type, @Nullable Level level, RandomSource random, BlockPos pos) {
        this.getOrCreateNextSpawnData(level, random, pos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(type).toString());
    }

    private boolean isNearPlayer(ServerLevel level, BlockPos pos) {
        return !this.detector.detect(level, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL, pos, (double)this.requiredPlayerRange, true).isEmpty();
    }

    public void serverTick(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.isNearPlayer(level, pos)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)level, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                ArrayList<Pair<Integer, BooleanProperty>> filledSlots = new ArrayList<Pair<Integer, BooleanProperty>>(SLOT_PROPERTIES_AND_INDEXES);
                filledSlots.removeIf(pair -> (Boolean)state.getValue((Property)pair.getSecond()) == false);
                Collections.shuffle(filledSlots);
                for (Pair pair2 : filledSlots) {
                    BooleanProperty property = (BooleanProperty)pair2.getSecond();
                    if (!state.hasProperty((Property)property) || !((Boolean)state.getValue((Property)property)).booleanValue() || !this.attemptSpawnTome((Integer)pair2.getFirst(), level, pos, false, null, 0)) continue;
                    this.delay((Level)level, pos);
                    break;
                }
                int fullSlots = 0;
                for (BooleanProperty property : ChiseledCanopyShelfBlock.SLOT_OCCUPIED_PROPERTIES) {
                    if (!state.hasProperty((Property)property) || !((Boolean)state.getValue((Property)property)).booleanValue()) continue;
                    ++fullSlots;
                }
                if (fullSlots == 0) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ChiseledCanopyShelfBlock.SPAWNER, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    private void delay(Level level, BlockPos pos) {
        RandomSource randomsource = level.getRandom();
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(p_337965_ -> this.setNextSpawnData(level, pos, (SpawnData)p_337965_.data()));
        this.broadcastEvent(level, pos, 1);
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        boolean flag1;
        this.spawnDelay = tag.getShort("Delay");
        boolean flag = tag.contains("SpawnData", 10);
        if (flag) {
            SpawnData spawndata = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("SpawnData")).resultOrPartial(p_186391_ -> TwilightForestMod.LOGGER.warn("Death Tome Spawner: Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new);
            this.setNextSpawnData(level, pos, spawndata);
        }
        if (flag1 = tag.contains("SpawnPotentials", 9)) {
            ListTag listtag = tag.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)listtag).resultOrPartial(p_186388_ -> TwilightForestMod.LOGGER.warn("Death Tome Spawner: Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        if (tag.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = tag.getShort("MinSpawnDelay");
            this.maxSpawnDelay = tag.getShort("MaxSpawnDelay");
        }
        if (tag.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = tag.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = tag.getShort("RequiredPlayerRange");
        }
        if (tag.contains("SpawnRange", 99)) {
            this.spawnRange = tag.getShort("SpawnRange");
        }
        if (tag.contains("SpawnCheckRange", 99)) {
            this.spawnCheckRange = tag.getShort("SpawnCheckRange");
        }
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putShort("Delay", (short)this.spawnDelay);
        tag.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        tag.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        tag.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        tag.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        tag.putShort("SpawnRange", (short)this.spawnRange);
        tag.putShort("SpawnCheckRange", (short)this.spawnCheckRange);
        if (this.nextSpawnData != null) {
            tag.put("SpawnData", (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(p_337966_ -> new IllegalStateException("Invalid SpawnData: " + p_337966_)));
        }
        tag.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).getOrThrow());
        return tag;
    }

    public boolean onEventTriggered(Level level, int id) {
        if (id == 1) {
            if (level.isClientSide()) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level level, BlockPos pos, SpawnData data) {
        this.nextSpawnData = data;
    }

    @Nullable
    public SpawnData getNextSpawnData() {
        return this.nextSpawnData;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level level, RandomSource pRandom, BlockPos pos) {
        if (this.nextSpawnData == null) {
            this.setNextSpawnData(level, pos, this.spawnPotentials.getRandom(pRandom).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        }
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public boolean attemptSpawnTome(int slot, ServerLevel level, BlockPos pos, boolean fire, @Nullable LivingEntity assailant, int maxTries) {
        RandomSource random = level.getRandom();
        SpawnData data = this.getOrCreateNextSpawnData((Level)level, random, pos);
        CompoundTag tag = data.entityToSpawn();
        BlockState shelf = level.getBlockState(pos);
        Direction facing = (Direction)shelf.getValue((Property)HorizontalDirectionalBlock.FACING);
        Optional optional = EntityType.by((CompoundTag)tag);
        if (optional.isEmpty() || !level.getBlockState(pos.relative(facing)).canBeReplaced()) {
            this.delay((Level)level, pos);
            return false;
        }
        double x = (double)pos.relative(facing).getX() + (random.nextDouble() - random.nextDouble()) * 2.0;
        double y = (double)pos.getY() + (random.nextDouble() - random.nextDouble());
        double z = (double)pos.relative(facing).getZ() + (random.nextDouble() - random.nextDouble()) * 2.0;
        if (level.noCollision(((EntityType)optional.get()).getSpawnAABB(x, y, z))) {
            BlockEntity blockEntity;
            Mob mob;
            Entity entity;
            boolean difficultyPreventsSpawn = !((EntityType)optional.get()).getCategory().isFriendly() && level.getDifficulty() == Difficulty.PEACEFUL;
            BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
            if (data.getCustomSpawnRules().isPresent()) {
                if (difficultyPreventsSpawn) {
                    return false;
                }
                SpawnData.CustomSpawnRules rules = (SpawnData.CustomSpawnRules)data.getCustomSpawnRules().get();
                if (!rules.isValidPosition(blockpos, level) && !fire) {
                    return false;
                }
            } else if (difficultyPreventsSpawn) {
                this.delay((Level)level, pos);
                return false;
            }
            if ((entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, processed -> {
                processed.moveTo(x, y, z, processed.getYRot(), processed.getXRot());
                if (fire) {
                    processed.setRemainingFireTicks(200);
                }
                if (assailant != null && processed instanceof Mob) {
                    Mob mob = (Mob)processed;
                    mob.setTarget(assailant);
                }
                return processed;
            })) == null) {
                this.delay((Level)level, pos);
                return false;
            }
            int k = level.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB(pos).inflate((double)this.spawnCheckRange), EntitySelector.NO_SPECTATORS).size();
            if (k >= this.maxNearbyEntities && !fire) {
                this.delay((Level)level, pos);
                return false;
            }
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                boolean flag1 = data.getEntityToSpawn().size() == 1 && data.getEntityToSpawn().contains("id", 8);
                EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)flag1);
                data.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
            }
            if (!level.tryAddFreshEntityWithPassengers(entity)) {
                this.delay((Level)level, pos);
                return false;
            }
            level.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, blockpos);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                mob.spawnAnim();
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof ChiseledCanopyShelfBlockEntity) {
                ChiseledCanopyShelfBlockEntity be = (ChiseledCanopyShelfBlockEntity)blockEntity;
                be.setItem(slot, ItemStack.EMPTY);
            }
            return true;
        }
        if (maxTries != 0) {
            this.attemptSpawnTome(slot, level, pos, fire, assailant, maxTries - 1);
        }
        return false;
    }
}

