/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.giantblock;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import twilightforest.TwilightForestMod;

public class GiantBlockBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private ResourceLocation parentBlock;

    public static <T extends ModelBuilder<T>> GiantBlockBuilder<T> begin(T parent, ExistingFileHelper helper) {
        return new GiantBlockBuilder<T>(parent, helper);
    }

    protected GiantBlockBuilder(T parent, ExistingFileHelper helper) {
        super(TwilightForestMod.prefix("giant_block"), parent, helper, false);
    }

    public GiantBlockBuilder<T> parentBlock(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"parent block must not be null");
        this.parentBlock = BuiltInRegistries.BLOCK.getKey((Object)block);
        return this;
    }

    public T end() {
        Preconditions.checkNotNull((Object)this.parentBlock, (Object)"giant block must have a parent block");
        return (T)super.end();
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        json.addProperty("parent_block", this.parentBlock.toString());
        return json;
    }
}

