/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.entity.boss.AlphaYeti;

public class AlphaYetiModel
extends HumanoidModel<AlphaYeti>
implements TrophyBlockModel {
    private static final ResourceLocation ALPHA_YETI_TEXTURE = TwilightForestMod.getModelTexture("yetialpha.png");

    public AlphaYetiModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 0.0f, 0.0f, 0.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 0.0f, 0.0f, 0.0f), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(80, 0).addBox(-24.0f, -60.0f, -18.0f, 48.0f, 72.0f, 36.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        body.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(121, 50).addBox(-17.0f, -7.0f, -1.5f, 34.0f, 29.0f, 2.0f), PartPose.offset((float)0.0f, (float)-37.0f, (float)-18.0f));
        body.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(64, 0).addBox(-6.0f, -6.0f, -1.5f, 12.0f, 12.0f, 2.0f), PartPose.offset((float)-14.0f, (float)-50.0f, (float)-18.0f));
        body.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(64, 0).addBox(-6.0f, -6.0f, -1.5f, 12.0f, 12.0f, 2.0f), PartPose.offset((float)14.0f, (float)-50.0f, (float)-18.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, -6.0f, -8.0f, 16.0f, 48.0f, 16.0f), PartPose.offset((float)-25.0f, (float)-26.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-1.0f, -6.0f, -8.0f, 16.0f, 48.0f, 16.0f), PartPose.offset((float)25.0f, (float)-26.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 66).addBox(-10.0f, 0.0f, -10.0f, 20.0f, 20.0f, 20.0f), PartPose.offset((float)-13.5f, (float)4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 66).addBox(-10.0f, 0.0f, -10.0f, 20.0f, 20.0f, 20.0f), PartPose.offset((float)13.5f, (float)4.0f, (float)0.0f));
        AlphaYetiModel.addPairHorns(body, -58.0f, 35.0f, 1);
        AlphaYetiModel.addPairHorns(body, -46.0f, 15.0f, 2);
        AlphaYetiModel.addPairHorns(body, -36.0f, -5.0f, 3);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public static LayerDefinition createTrophy() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(80, 0).addBox(-24.0f, -24.0f, -18.0f, 48.0f, 54.0f, 36.0f).texOffs(64, 0).addBox(8.0f, -20.0f, -19.5f, 12.0f, 12.0f, 2.0f).texOffs(121, 50).addBox(-17.0f, -8.0f, -19.5f, 34.0f, 29.0f, 2.0f).texOffs(64, 0).addBox(-20.0f, -20.0f, -19.5f, 12.0f, 12.0f, 2.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        AlphaYetiModel.addPairHorns(head, -16.0f, 35.0f, 1);
        AlphaYetiModel.addPairHorns(head, -4.0f, 15.0f, 2);
        AlphaYetiModel.addPairHorns(head, 6.0f, -5.0f, 3);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    private static void addPairHorns(PartDefinition partdefinition, float height, float zangle, int set) {
        PartDefinition leftHorn = partdefinition.addOrReplaceChild("left_horn_" + set, CubeListBuilder.create().texOffs(0, 108).addBox(-9.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.offsetAndRotation((float)-24.0f, (float)height, (float)-8.0f, (float)0.0f, (float)-0.5235988f, (float)(zangle * ((float)Math.PI / 180))));
        leftHorn.addOrReplaceChild("left_horn_" + set + "_top", CubeListBuilder.create().texOffs(40, 108).addBox(-14.0f, -4.0f, -4.0f, 18.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.34906584f, (float)(zangle * ((float)Math.PI / 180))));
        PartDefinition rightHorn = partdefinition.addOrReplaceChild("right_horn_" + set, CubeListBuilder.create().texOffs(0, 108).addBox(-1.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.offsetAndRotation((float)24.0f, (float)height, (float)0.0f, (float)0.0f, (float)0.5235988f, (float)(-zangle * ((float)Math.PI / 180))));
        rightHorn.addOrReplaceChild("right_horn_" + set + "_top", CubeListBuilder.create().texOffs(40, 108).addBox(-2.0f, -4.0f, -4.0f, 18.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.34906584f, (float)(-zangle * ((float)Math.PI / 180))));
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setupAnim(AlphaYeti entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.xRot = headPitch * ((float)Math.PI / 180);
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        float f6 = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float f7 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.yRot = -(0.1f - f6 * 0.6f);
        this.leftArm.yRot = 0.1f - f6 * 0.6f;
        this.rightArm.xRot = -1.5707964f;
        this.leftArm.xRot = -1.5707964f;
        this.rightArm.xRot -= f6 * 1.2f - f7 * 0.4f;
        this.leftArm.xRot -= f6 * 1.2f - f7 * 0.4f;
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightArm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftArm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.body.y = -6.0f;
        this.rightLeg.y = 4.0f;
        this.leftLeg.y = 4.0f;
        if (entity.isTired()) {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightArm.xRot -= 0.62831855f;
            this.leftArm.xRot -= 0.62831855f;
            this.rightLeg.xRot = -1.2566371f;
            this.leftLeg.xRot = -1.2566371f;
            this.rightLeg.yRot = 0.31415927f;
            this.leftLeg.yRot = -0.31415927f;
            this.body.y = 6.0f;
            this.rightLeg.y = 12.0f;
            this.leftLeg.y = 12.0f;
        }
        if (entity.isRampaging()) {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.66f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.66f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.yRot += Mth.cos((float)(limbSwing * 0.25f)) * 0.5f + 0.5f;
            this.leftArm.yRot -= Mth.cos((float)(limbSwing * 0.25f)) * 0.5f + 0.5f;
            this.rightArm.xRot += 3.926991f;
            this.leftArm.xRot += 3.926991f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
        }
        if (entity.isVehicle()) {
            this.rightArm.xRot += (float)Math.PI;
            this.leftArm.xRot += (float)Math.PI;
        }
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        stack.scale(0.2f, 0.2f, 0.2f);
        stack.translate(0.0f, -1.5f, 0.0f);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)ALPHA_YETI_TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
    }
}

