/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.Kobold;

public class KoboldModel
extends HumanoidModel<Kobold> {
    private final ModelPart jaw = this.getHead().getChild("mouth");
    private boolean isJumping;

    public KoboldModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? KoboldModel.createJappaModel() : KoboldModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -7.0f, -3.0f, 7.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 20).addBox(0.0f, -4.0f, 0.0f, 4.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)3.5f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)0.2617994f, (float)-0.3490659f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(48, 25).addBox(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)-0.2617994f, (float)0.3490659f));
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(28, 0).addBox(-1.5f, -2.0f, -2.0f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)-3.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(28, 5).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-3.0f, (float)0.20944f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(12, 19).addBox(0.0f, 0.0f, 0.0f, 7.0f, 7.0f, 4.0f), PartPose.offset((float)-3.5f, (float)12.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(36, 17).addBox(-3.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)-3.5f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(36, 17).addBox(0.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)3.5f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)-2.0f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 20).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)2.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -6.0f, -3.0f, 7.0f, 6.0f, 6.0f).texOffs(20, 0).addBox(-1.5f, -3.0f, -6.0f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(26, 5).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)0.21816616f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3089969f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(42, 0).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3089969f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(12, 12).addBox(-3.5f, 0.0f, -2.0f, 7.0f, 7.0f, 4.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(34, 12).addBox(-2.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)-4.5f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(34, 22).addBox(-1.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)4.5f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 12).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)-1.9f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)1.9f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Kobold entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.xRot = -0.47123894f;
        this.leftArm.xRot = -0.47123894f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.19f)) * 0.15f + 0.05f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.19f)) * 0.15f + 0.05f;
        this.rightArm.xRot += Mth.sin((float)(ageInTicks * 0.267f)) * 0.25f;
        this.leftArm.xRot -= Mth.sin((float)(ageInTicks * 0.267f)) * 0.25f;
        this.jaw.xRot = this.isJumping ? 1.44f : 0.20944f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        super.translateToHand(arm, stack);
        stack.translate(0.0f, -0.075f, 0.0f);
        stack.scale(0.75f, 0.75f, 0.75f);
    }

    public void prepareMobModel(Kobold entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.isJumping = !entity.isNoAi() && entity.getDeltaMovement().y() > 0.0;
    }
}

