/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.SlimeBeetle;

public class SlimeBeetleModel<T extends SlimeBeetle>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightLeg1;
    private final ModelPart rightLeg2;
    private final ModelPart rightLeg3;
    private final ModelPart leftLeg1;
    private final ModelPart leftLeg2;
    private final ModelPart leftLeg3;
    private final ModelPart tailBottom;
    private final ModelPart tailTop;
    private final ModelPart slime;
    private final ModelPart slimeCenter;

    public SlimeBeetleModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.rightLeg1 = root.getChild("right_leg_1");
        this.rightLeg2 = root.getChild("right_leg_2");
        this.rightLeg3 = root.getChild("right_leg_3");
        this.leftLeg1 = root.getChild("left_leg_1");
        this.leftLeg2 = root.getChild("left_leg_2");
        this.leftLeg3 = root.getChild("left_leg_3");
        this.tailBottom = root.getChild("tail_bottom");
        this.tailTop = this.tailBottom.getChild("tail_top");
        this.slimeCenter = this.tailTop.getChild("slime_center");
        this.slime = this.slimeCenter.getChild("slime");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? SlimeBeetleModel.createJappaModel() : SlimeBeetleModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition base = meshdefinition.getRoot();
        PartDefinition headpart = base.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-5.0f));
        headpart.addOrReplaceChild("left_antenna", CubeListBuilder.create().texOffs(38, 4).addBox(0.0f, -0.5f, -0.5f, 12.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)1.047198f, (float)-0.296706f));
        headpart.addOrReplaceChild("right_antenna", CubeListBuilder.create().texOffs(38, 4).addBox(0.0f, -0.5f, -0.5f, 12.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)2.094395f, (float)0.296706f));
        headpart.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(15, 12).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)3.0f, (float)-2.0f, (float)-5.0f));
        headpart.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(15, 12).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-3.0f, (float)-2.0f, (float)-5.0f));
        headpart.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(17, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)-6.0f));
        base.addOrReplaceChild("body", CubeListBuilder.create().texOffs(31, 6).addBox(-4.0f, -11.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)7.0f, (float)1.570796f, (float)0.0f, (float)0.0f));
        base.addOrReplaceChild("left_leg_1", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)0.2792527f, (float)0.3490659f));
        base.addOrReplaceChild("right_leg_1", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)-0.2792527f, (float)-0.3490659f));
        base.addOrReplaceChild("left_leg_2", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)-1.0f, (float)0.0f, (float)-0.2792527f, (float)0.3490659f));
        base.addOrReplaceChild("right_leg_2", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)-1.0f, (float)0.0f, (float)0.2792527f, (float)-0.3490659f));
        base.addOrReplaceChild("left_leg_3", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)4.0f, (float)0.0f, (float)-0.6981317f, (float)0.3490659f));
        base.addOrReplaceChild("right_leg_3", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)4.0f, (float)0.0f, (float)0.6981317f, (float)-0.3490659f));
        base.addOrReplaceChild("connector", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -3.0f, -1.0f, 6.0f, 6.0f, 1.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-4.0f));
        PartDefinition tail1 = base.addOrReplaceChild("tail_bottom", CubeListBuilder.create().texOffs(0, 20).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)9.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail_top", CubeListBuilder.create().texOffs(0, 20).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)2.0f));
        PartDefinition center = tail2.addOrReplaceChild("slime_center", CubeListBuilder.create().texOffs(32, 24).addBox(-4.0f, -10.0f, -7.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        center.addOrReplaceChild("slime", CubeListBuilder.create().texOffs(0, 40).addBox(-6.0f, -12.0f, -9.0f, 12.0f, 12.0f, 12.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)-8.0f));
        head.addOrReplaceChild("right_antenna", CubeListBuilder.create().texOffs(38, 4).addBox(-12.0f, -0.5f, -0.5f, 12.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-0.5f, (float)-1.5f, (float)-5.0f, (float)0.0f, (float)-0.7853982f, (float)0.7853982f));
        head.addOrReplaceChild("left_antenna", CubeListBuilder.create().texOffs(38, 6).addBox(0.0f, -0.5f, -0.5f, 12.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.5f, (float)-1.5f, (float)-5.0f, (float)0.0f, (float)0.7853982f, (float)-0.7853982f));
        head.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-2.5f, (float)-1.0f, (float)-4.5f));
        head.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(16, 12).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)2.5f, (float)-1.0f, (float)-4.5f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 8).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)-8.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg_1", CubeListBuilder.create().texOffs(40, 0).addBox(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)20.0f, (float)-6.0f, (float)0.0f, (float)-0.43633232f, (float)-0.43633232f));
        partdefinition.addOrReplaceChild("right_leg_2", CubeListBuilder.create().texOffs(40, 0).addBox(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)0.21816616f, (float)-0.43633232f));
        partdefinition.addOrReplaceChild("right_leg_3", CubeListBuilder.create().texOffs(40, 0).addBox(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)0.7853982f, (float)-0.43633232f));
        partdefinition.addOrReplaceChild("left_leg_1", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)20.0f, (float)-6.0f, (float)0.0f, (float)0.43633232f, (float)0.43633232f));
        partdefinition.addOrReplaceChild("left_leg_2", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)-0.21816616f, (float)0.43633232f));
        partdefinition.addOrReplaceChild("left_leg_3", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)-0.7853982f, (float)0.43633232f));
        PartDefinition tailBottom = partdefinition.addOrReplaceChild("tail_bottom", CubeListBuilder.create().texOffs(0, 34).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)2.0f));
        PartDefinition tailTop = tailBottom.addOrReplaceChild("tail_top", CubeListBuilder.create().texOffs(32, 28).addBox(-3.0f, -9.0f, -1.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition center = tailTop.addOrReplaceChild("slime_center", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -10.0f, -5.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-9.0f, (float)2.0f));
        center.addOrReplaceChild("slime", CubeListBuilder.create().texOffs(16, 40).addBox(-6.0f, -12.0f, -7.0f, 12.0f, 12.0f, 12.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        this.slime.visible = false;
        this.root().render(stack, builder, light, overlay, color);
    }

    public void renderTail(PoseStack stack, VertexConsumer builder, int light, int overlay) {
        this.tailBottom.render(stack, builder, light, overlay);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legZ;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftLeg1.zRot = legZ = 0.28559935f;
        this.rightLeg1.zRot = -legZ;
        this.leftLeg2.zRot = legZ * 0.74f;
        this.rightLeg2.zRot = -legZ * 0.74f;
        this.leftLeg3.zRot = legZ;
        this.rightLeg3.zRot = -legZ;
        float var9 = -0.0f;
        float var10 = 0.3926991f;
        this.leftLeg1.yRot = var10 * 2.0f + var9;
        this.rightLeg1.yRot = -var10 * 2.0f - var9;
        this.leftLeg2.yRot = var10 + var9;
        this.rightLeg2.yRot = -var10 - var9;
        this.leftLeg3.yRot = -var10 * 2.0f + var9;
        this.rightLeg3.yRot = var10 * 2.0f - var9;
        float var11 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float var12 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float var14 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float var15 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float var16 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float var18 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.leftLeg1.yRot += var11;
        this.rightLeg1.yRot -= var11;
        this.leftLeg2.yRot += var12;
        this.rightLeg2.yRot -= var12;
        this.leftLeg3.yRot += var14;
        this.rightLeg3.yRot -= var14;
        this.leftLeg1.zRot += var15;
        this.rightLeg1.zRot -= var15;
        this.leftLeg2.zRot += var16;
        this.rightLeg2.zRot -= var16;
        this.leftLeg3.zRot += var18;
        this.rightLeg3.zRot -= var18;
        this.tailBottom.xRot = Mth.cos((float)(ageInTicks * 0.3335f)) * 0.15f;
        this.tailTop.xRot = Mth.cos((float)(ageInTicks * 0.4445f)) * 0.2f;
        this.slimeCenter.xRot = Mth.cos((float)(ageInTicks * 0.5555f + 0.25f)) * 0.25f;
    }
}

