/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class CloudPuffParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    CloudPuffParticle(ClientLevel level, double X, double Y, double Z, double XSpeed, double YSpeed, double ZSpeed, SpriteSet sprites) {
        super(level, X, Y, Z, 0.0, 0.0, 0.0);
        float f1;
        this.friction = 0.96f;
        this.sprites = sprites;
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += XSpeed;
        this.yd += YSpeed;
        this.zd += ZSpeed;
        this.rCol = f1 = 1.0f - (float)(Math.random() * (double)0.3f);
        this.gCol = f1;
        this.bCol = f1;
        this.quadSize *= 0.875f;
        int i = (int)(8.0 / (Math.random() * 0.8 + 0.3));
        this.lifetime = (int)Math.max((float)i * 2.5f, 1.0f);
        this.hasPhysics = false;
        this.setSpriteFromAge(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float partialTick) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.setSpriteFromAge(this.sprites);
        }
    }

    public record Factory(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CloudPuffParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

