/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.entity.monster.MazeSlime;

public class MazeSlimeRenderer
extends MobRenderer<MazeSlime, SlimeModel<MazeSlime>> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("mazeslime.png");

    public MazeSlimeRenderer(EntityRendererProvider.Context context, float shadowSize) {
        super(context, (EntityModel)new SlimeModel(context.bakeLayer(TFModelLayers.MAZE_SLIME)), shadowSize);
        this.addLayer((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, context.getModelSet()));
    }

    public void render(MazeSlime entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        this.shadowRadius = 0.25f * (float)entity.getSize();
        super.render((LivingEntity)entity, entityYaw, partialTicks, stack, buffer, light);
    }

    protected void scale(MazeSlime entity, PoseStack stack, float partialTicks) {
        stack.scale(0.999f, 0.999f, 0.999f);
        stack.translate(0.0, (double)0.001f, 0.0);
        float size = entity.getSize();
        float squishFactor = Mth.lerp((float)partialTicks, (float)entity.oSquish, (float)entity.squish) / (size * 0.5f + 1.0f);
        float scaledSquish = 1.0f / (squishFactor + 1.0f);
        stack.scale(scaledSquish * size, 1.0f / scaledSquish * size, scaledSquish * size);
    }

    public ResourceLocation getTextureLocation(MazeSlime entity) {
        return TEXTURE;
    }
}

