/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import twilightforest.TwilightForestMod;
import twilightforest.client.UncraftingScreen;
import twilightforest.compat.RecipeViewerConstants;
import twilightforest.compat.jei.FakeEntityType;
import twilightforest.compat.jei.FakeItemEntity;
import twilightforest.compat.jei.categories.CrumbleHornCategory;
import twilightforest.compat.jei.categories.JEIUncraftingCategory;
import twilightforest.compat.jei.categories.MoonwormQueenCategory;
import twilightforest.compat.jei.categories.OminousFireCategory;
import twilightforest.compat.jei.categories.TransformationPowderCategory;
import twilightforest.compat.jei.extension.NoTemplateSmithingExtension;
import twilightforest.compat.jei.extension.ScepterRepairExtension;
import twilightforest.compat.jei.renderers.EntityHelper;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.compat.jei.renderers.FakeItemEntityHelper;
import twilightforest.compat.jei.renderers.FakeItemEntityRenderer;
import twilightforest.compat.jei.subtype.CasketSubtypeInterpreter;
import twilightforest.compat.jei.util.CrumbleRecipe;
import twilightforest.compat.jei.util.OminousFireRecipe;
import twilightforest.compat.jei.util.TransformationRecipe;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFMenuTypes;
import twilightforest.inventory.UncraftingMenu;
import twilightforest.item.recipe.MoonwormQueenRepairRecipe;
import twilightforest.item.recipe.NoTemplateSmithingRecipe;
import twilightforest.item.recipe.ScepterRepairRecipe;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final IIngredientType<FakeEntityType> ENTITY_TYPE = () -> FakeEntityType.class;
    public static final IIngredientType<FakeItemEntity> FAKE_ITEM_ENTITY = () -> FakeItemEntity.class;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!TFConfig.disableEntireTable) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.TRANSFORMATION_POWDER.get()), new RecipeType[]{TransformationPowderCategory.TRANSFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.EXANIMATE_ESSENCE.get()), new RecipeType[]{OminousFireCategory.OMINOUS_FIRE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.CRUMBLE_HORN.get()), new RecipeType[]{CrumbleHornCategory.CRUMBLE_HORN});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.MOONWORM_QUEEN.get()), new RecipeType[]{MoonwormQueenCategory.MOONWORM_QUEEN});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(TFItems.KEEPSAKE_CASKET.asItem(), (IIngredientSubtypeInterpreter)CasketSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(UncraftingMenu.class, (MenuType)TFMenuTypes.UNCRAFTING.get(), RecipeTypes.CRAFTING, 11, 9, 20, 36);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityHelper(), (IIngredientRenderer)new EntityRenderer(16));
        registration.register(FAKE_ITEM_ENTITY, Collections.emptyList(), (IIngredientHelper)new FakeItemEntityHelper(), (IIngredientRenderer)new FakeItemEntityRenderer(16));
    }

    public ResourceLocation getPluginUid() {
        return TwilightForestMod.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIUncraftingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TransformationPowderCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OminousFireCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrumbleHornCategory(registration.getJeiHelpers().getGuiHelper())});
        RecipeManager manager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        if (!manager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().filter(holder -> holder.value() instanceof MoonwormQueenRepairRecipe).toList().isEmpty()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MoonwormQueenCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getSmithingCategory().addExtension(NoTemplateSmithingRecipe.class, (ISmithingCategoryExtension)new NoTemplateSmithingExtension());
        registration.getCraftingCategory().addExtension(ScepterRepairRecipe.class, (ICraftingCategoryExtension)new ScepterRepairExtension());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        if (!TFConfig.disableEntireTable) {
            List<RecipeHolder<? extends CraftingRecipe>> recipes = RecipeViewerConstants.getAllUncraftingRecipes(manager);
            registration.addRecipes(JEIUncraftingCategory.UNCRAFTING, recipes.stream().map(RecipeHolder::value).toList());
        }
        registration.addRecipes(TransformationPowderCategory.TRANSFORMATION, RecipeViewerConstants.getTransformationPowderRecipes().stream().map(info -> new TransformationRecipe(new FakeEntityType(info.input()), new FakeEntityType(info.output()), info.reversible())).toList());
        registration.addRecipes(OminousFireCategory.OMINOUS_FIRE, RecipeViewerConstants.getOminousFireRecipes().stream().map(info -> new OminousFireRecipe(new FakeEntityType(info.input()), new FakeEntityType(info.output()))).toList());
        registration.addRecipes(CrumbleHornCategory.CRUMBLE_HORN, RecipeViewerConstants.getCrumbleHornRecipes().stream().map(info -> new CrumbleRecipe((Block)info.getFirst(), (Block)info.getSecond())).toList());
        registration.addRecipes(MoonwormQueenCategory.MOONWORM_QUEEN, List.of(new MoonwormQueenRepairRecipe(CraftingBookCategory.MISC)));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UncraftingScreen.class, 34, 33, 27, 20, new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        registration.addRecipeClickArea(UncraftingScreen.class, 115, 33, 27, 20, new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(TFItems.MAGIC_PAINTING.toStack()));
    }
}

