/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.FakeItemEntity;
import twilightforest.compat.jei.JEICompat;
import twilightforest.compat.jei.renderers.FakeItemEntityRenderer;
import twilightforest.compat.jei.util.CrumbleRecipe;
import twilightforest.init.TFItems;

public class CrumbleHornCategory
implements IRecipeCategory<CrumbleRecipe> {
    public static final RecipeType<CrumbleRecipe> CRUMBLE_HORN = RecipeType.create((String)"twilightforest", (String)"crumble_horn", CrumbleRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable crumbleSlot;
    private final Component localizedName;
    private final FakeItemEntityRenderer itemRenderer = new FakeItemEntityRenderer(32);

    public CrumbleHornCategory(IGuiHelper helper) {
        ResourceLocation location = TwilightForestMod.getGuiTexture("crumble_horn_jei.png");
        this.background = helper.createDrawable(location, 0, 0, 116, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)TFItems.CRUMBLE_HORN.get()).getDefaultInstance());
        this.crumbleSlot = helper.createDrawable(location, 116, 0, 26, 26);
        this.localizedName = Component.translatable((String)"gui.twilightforest.crumble_horn_jei");
    }

    public RecipeType<CrumbleRecipe> getRecipeType() {
        return CRUMBLE_HORN;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrumbleRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.output() != Blocks.AIR) {
            this.crumbleSlot.draw(graphics, 76, 14);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrumbleRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addItemStack(new ItemStack((ItemLike)recipe.input().asItem()));
        if (recipe.output() != Blocks.AIR) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 19).addItemStack(new ItemStack((ItemLike)recipe.output().asItem()));
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 12).setCustomRenderer(JEICompat.FAKE_ITEM_ENTITY, (IIngredientRenderer)this.itemRenderer).addIngredient(JEICompat.FAKE_ITEM_ENTITY, (Object)new FakeItemEntity(new ItemStack((ItemLike)recipe.input().asItem())));
        }
    }
}

