/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.components.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.alchemy.PotionContents;

public record PotionFlaskComponent(PotionContents potion, int doses, int breakage, boolean breakable) {
    public static final PotionFlaskComponent EMPTY = new PotionFlaskComponent(PotionContents.EMPTY, 0, 0, true);
    public static final PotionFlaskComponent EMPTY_UNBREAKABLE = new PotionFlaskComponent(PotionContents.EMPTY, 0, 0, false);
    public static final Codec<PotionFlaskComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PotionContents.CODEC.optionalFieldOf("potion", (Object)PotionContents.EMPTY).forGetter(PotionFlaskComponent::potion), (App)Codec.INT.optionalFieldOf("doses", (Object)0).forGetter(PotionFlaskComponent::doses), (App)Codec.INT.optionalFieldOf("breakage", (Object)0).forGetter(PotionFlaskComponent::breakage), (App)Codec.BOOL.optionalFieldOf("breakable", (Object)true).forGetter(PotionFlaskComponent::breakable)).apply((Applicative)instance, PotionFlaskComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionFlaskComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)PotionContents.STREAM_CODEC, PotionFlaskComponent::potion, (StreamCodec)ByteBufCodecs.INT, PotionFlaskComponent::doses, (StreamCodec)ByteBufCodecs.INT, PotionFlaskComponent::breakage, (StreamCodec)ByteBufCodecs.BOOL, PotionFlaskComponent::breakable, PotionFlaskComponent::new);

    public PotionFlaskComponent tryAddDose(PotionContents potion) {
        return new PotionFlaskComponent(potion, this.doses() + 1, this.breakage(), this.breakable());
    }

    public PotionFlaskComponent removeDose() {
        int newDose = this.doses() - 1;
        return new PotionFlaskComponent(newDose < 1 ? PotionContents.EMPTY : this.potion(), newDose, this.breakable() ? this.breakage() + 1 : this.breakage(), this.breakable());
    }
}

