/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public record SpeleothemVarietyConfig(String type, List<ResourceLocation> baseStalactites, List<ResourceLocation> oreStalactites, List<ResourceLocation> stalagmites, float oreChance, float stalactiteChance, float stalagmiteChance, boolean replace) {
    public static final Codec<SpeleothemVarietyConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(String::toLowerCase, String::toLowerCase).fieldOf("type").forGetter(SpeleothemVarietyConfig::type), (App)ResourceLocation.CODEC.listOf().fieldOf("base_stalactites").forGetter(SpeleothemVarietyConfig::baseStalactites), (App)ResourceLocation.CODEC.listOf().fieldOf("ore_stalactites").forGetter(SpeleothemVarietyConfig::oreStalactites), (App)ResourceLocation.CODEC.listOf().fieldOf("stalagmites").forGetter(SpeleothemVarietyConfig::stalagmites), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ore_chance").forGetter(SpeleothemVarietyConfig::oreChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stalactite_chance").forGetter(SpeleothemVarietyConfig::stalactiteChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stalagmite_chance").forGetter(SpeleothemVarietyConfig::stalagmiteChance), (App)Codec.BOOL.fieldOf("replace").orElse((Object)false).forGetter(SpeleothemVarietyConfig::replace)).apply((Applicative)instance, SpeleothemVarietyConfig::new));

    public boolean shouldDoAStalactite(RandomSource rand) {
        return rand.nextFloat() < this.stalactiteChance();
    }

    public boolean shouldDoAStalagmite(RandomSource rand) {
        return rand.nextFloat() < this.stalagmiteChance();
    }
}

