/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class GroundAttackGoal
extends Goal {
    private static final double MIN_RANGE_SQ = 2.0;
    private static final double MAX_RANGE_SQ = 9.0;
    private static final int FREQ = 24;
    private final Minoshroom attacker;
    private LivingEntity attackTarget;
    private int cooldown;
    private int attackTick;

    public GroundAttackGoal(Minoshroom minoshroom) {
        this.attacker = minoshroom;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.attackTarget = this.attacker.getTarget();
        if (this.cooldown-- > 0 || this.attackTarget == null) {
            return false;
        }
        double distance = this.attacker.distanceToSqr((Entity)this.attackTarget);
        if (distance < 2.0 || distance > 9.0) {
            return false;
        }
        if (!this.attacker.onGround()) {
            return false;
        }
        if (this.attacker.hasLineOfSight((Entity)this.attackTarget)) {
            return this.attacker.getRandom().nextInt(24) == 0;
        }
        return this.attacker.getRandom().nextInt(20) == 0;
    }

    public void start() {
        this.cooldown = 200 + this.attacker.getRandom().nextInt(200);
        this.attackTick = 30 + this.attacker.getRandom().nextInt(30);
        this.attacker.setMaxCharge(this.attackTick);
        this.attacker.setGroundAttackCharge(true);
    }

    public boolean canContinueToUse() {
        return this.attackTick >= 0;
    }

    public void stop() {
        this.attackTick = 0;
        this.attackTarget = null;
    }

    public void tick() {
        this.attacker.getLookControl().setLookAt((Entity)this.attackTarget, 30.0f, 30.0f);
        this.attacker.getMoveControl().operation = MoveControl.Operation.WAIT;
        if (this.attackTick-- <= 0) {
            this.attacker.setGroundAttackCharge(false);
            this.attacker.playSound((SoundEvent)TFSounds.MINOSHROOM_SLAM.get(), 2.0f, 1.0f + this.attacker.getRandom().nextFloat() * 0.1f);
            this.attacker.gameEvent((Holder)GameEvent.HIT_GROUND);
            AABB selection = new AABB((double)((float)this.attacker.blockPosition().getX() - 7.5f), (double)this.attacker.blockPosition().getY(), (double)((float)this.attacker.blockPosition().getZ() - 7.5f), (double)((float)this.attacker.blockPosition().getX() + 7.5f), (double)((float)this.attacker.blockPosition().getY() + 3.0f), (double)((float)this.attacker.blockPosition().getZ() + 7.5f));
            List hit = this.attacker.level().getEntitiesOfClass(Entity.class, selection, entity -> entity instanceof Player);
            for (Entity entity2 : hit) {
                if (!entity2.onGround()) continue;
                entity2.push(0.0, 0.23, 0.0);
                entity2.hurt(TFDamageTypes.getEntityDamageSource(this.attacker.level(), TFDamageTypes.SLAM, (Entity)this.attacker, new EntityType[0]), (float)(this.attacker.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.5));
            }
        }
    }
}

