/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.boss.Naga;
import twilightforest.init.TFSounds;
import twilightforest.util.entities.EntityUtil;

public class NagaMovementPattern
extends Goal {
    private final Naga naga;
    private MovementState state;
    private int stateCounter;
    private boolean clockwise;
    private boolean stunCalculated;

    public NagaMovementPattern(Naga naga) {
        this.naga = naga;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.stop();
    }

    public boolean canUse() {
        return this.naga.getTarget() != null && this.naga.areSelfAndTargetInHome((Entity)this.naga.getTarget());
    }

    public void stop() {
        this.state = MovementState.CIRCLE;
        this.stateCounter = 15;
        this.clockwise = false;
    }

    public void tick() {
        if (!this.naga.getNavigation().isDone()) {
            if (this.naga.getNavigation().isStuck()) {
                this.naga.getNavigation().stop();
            }
            return;
        }
        if (this.stateCounter-- <= 0) {
            this.transitionState();
        } else {
            switch (this.state.ordinal()) {
                case 0: {
                    this.naga.getNavigation().stop();
                    if (this.naga.getTarget() != null) {
                        this.naga.getLookControl().setLookAt((Entity)this.naga.getTarget(), 30.0f, 30.0f);
                        this.naga.lookAt((Entity)this.naga.getTarget(), 30.0f, 30.0f);
                    }
                    this.naga.zza = 0.1f;
                    if (this.stunCalculated) break;
                    float healthRatio = 1.0f - this.naga.getHealth() / this.naga.getMaxHealth() - 0.25f;
                    float chance = Mth.clamp((float)(healthRatio + (float)this.naga.level().getCurrentDifficultyAt(this.naga.blockPosition()).getDifficulty().getId() * 0.05f), (float)0.0f, (float)0.5f);
                    float randChance = this.naga.getRandom().nextFloat() * 0.75f;
                    boolean stunless = randChance < chance;
                    this.naga.setStunlessCharging(stunless);
                    this.stunCalculated = true;
                    break;
                }
                case 1: {
                    this.naga.getNavigation().stop();
                    this.crumbleBelowTarget(2);
                    this.crumbleBelowTarget(3);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.naga.getTarget() != null) {
                        BlockPos tpoint = this.findCirclePoint(this.clockwise, 5.0, Math.PI);
                        this.naga.getNavigation().moveTo((double)tpoint.getX(), (double)tpoint.getY(), (double)tpoint.getZ(), 1.5);
                    }
                    this.naga.setCharging(true);
                    break;
                }
                case 4: {
                    this.naga.setCharging(false);
                    this.naga.setDazed(false);
                    double radius = this.stateCounter % 2 == 0 ? 12.0 : 14.0;
                    double rotation = 1.0;
                    if (this.stateCounter == 2) {
                        radius = 16.0;
                    }
                    if (this.stateCounter == 1) {
                        rotation = 0.1;
                    }
                    if (this.naga.getTarget() == null) break;
                    BlockPos tpoint = this.findCirclePoint(this.clockwise, radius, rotation);
                    this.naga.getNavigation().moveTo((double)tpoint.getX(), (double)tpoint.getY(), (double)tpoint.getZ(), 1.0);
                    break;
                }
                case 5: {
                    this.naga.getNavigation().stop();
                    this.naga.setDazed(true);
                    this.naga.setCharging(false);
                }
            }
        }
    }

    private void transitionState() {
        switch (this.state.ordinal()) {
            case 0: {
                boolean bl = this.clockwise = !this.clockwise;
                if (this.naga.getTarget() != null && this.naga.getTarget().getBoundingBox().minY > this.naga.getBoundingBox().maxY) {
                    this.doCrumblePlayer();
                    break;
                }
                this.doCharge(this.naga.isStunlessCharging());
                break;
            }
            case 1: {
                this.doCharge(this.naga.isStunlessCharging());
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.doCircle();
                break;
            }
            case 4: {
                this.doIntimidate();
            }
        }
    }

    public void doDaze() {
        this.state = MovementState.DAZE;
        this.naga.getNavigation().stop();
        this.stateCounter = 60 + this.naga.getRandom().nextInt(40);
    }

    public void doCircle() {
        this.state = MovementState.CIRCLE;
        this.stateCounter += 10 + this.naga.getRandom().nextInt(10);
        this.stunCalculated = false;
    }

    public void forceCircle() {
        this.state = MovementState.CIRCLE;
        this.stateCounter = 10 + this.naga.getRandom().nextInt(10);
        this.stunCalculated = false;
    }

    public void doCrumblePlayer() {
        this.state = MovementState.CRUMBLE;
        this.naga.getNavigation().stop();
        this.stateCounter = 20 + this.naga.getRandom().nextInt(20);
    }

    private void doCharge(boolean stunless) {
        this.state = stunless ? MovementState.STUNLESS_CHARGE : MovementState.CHARGE;
        this.stateCounter = 2;
    }

    private void doIntimidate() {
        this.state = MovementState.INTIMIDATE;
        this.naga.playSound((SoundEvent)TFSounds.NAGA_RATTLE.get(), 4.0f, this.naga.getVoicePitch());
        this.naga.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.stateCounter += 15 + this.naga.getRandom().nextInt(10);
    }

    private void crumbleBelowTarget(int range) {
        if (!EventHooks.canEntityGrief((Level)this.naga.level(), (Entity)this.naga) || this.naga.getTarget() == null) {
            return;
        }
        int targetY = (int)this.naga.getTarget().getBoundingBox().minY;
        int floor = (int)this.naga.getBoundingBox().minY;
        if (targetY > floor) {
            int dx = (int)this.naga.getTarget().getX() + this.naga.getRandom().nextInt(range) - this.naga.getRandom().nextInt(range);
            int dz = (int)this.naga.getTarget().getZ() + this.naga.getRandom().nextInt(range) - this.naga.getRandom().nextInt(range);
            int dy = targetY - this.naga.getRandom().nextInt(range) + this.naga.getRandom().nextInt(range > 1 ? range - 1 : range);
            if (dy <= floor) {
                dy = targetY;
            }
            BlockPos pos = new BlockPos(dx, dy, dz);
            if (EntityUtil.canDestroyBlock(this.naga.level(), pos, (Entity)this.naga)) {
                this.naga.level().destroyBlock(pos, true);
                for (int k = 0; k < 20; ++k) {
                    double d = this.naga.getRandom().nextGaussian() * 0.02;
                    double d1 = this.naga.getRandom().nextGaussian() * 0.02;
                    double d2 = this.naga.getRandom().nextGaussian() * 0.02;
                    this.naga.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.naga.getX() + (double)(this.naga.getRandom().nextFloat() * this.naga.getBbWidth() * 2.0f) - (double)this.naga.getBbWidth(), this.naga.getY() + (double)(this.naga.getRandom().nextFloat() * this.naga.getBbHeight()), this.naga.getZ() + (double)(this.naga.getRandom().nextFloat() * this.naga.getBbWidth() * 2.0f) - (double)this.naga.getBbWidth(), d, d1, d2);
                }
            }
        }
    }

    private BlockPos findCirclePoint(boolean clockwise, double radius, double rotation) {
        LivingEntity toCircle = this.naga.getTarget();
        double vecx = this.naga.getX() - toCircle.getX();
        double vecz = this.naga.getZ() - toCircle.getZ();
        float rangle = (float)Math.atan2(vecz, vecx);
        double dx = (double)Mth.cos((float)(rangle += (float)(clockwise ? rotation : -rotation))) * radius;
        double dz = (double)Mth.sin((float)rangle) * radius;
        double dy = Math.min(this.naga.getBoundingBox().minY, toCircle.getY());
        return BlockPos.containing((double)(toCircle.getX() + dx), (double)dy, (double)(toCircle.getZ() + dz));
    }

    public MovementState getState() {
        return this.state;
    }

    public static enum MovementState {
        INTIMIDATE,
        CRUMBLE,
        CHARGE,
        STUNLESS_CHARGE,
        CIRCLE,
        DAZE;

    }
}

