/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss.bar;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class ClientTFBossBar
extends LerpingBossEvent {
    private int color;
    private static final ResourceLocation BAR_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/white_background");
    private static final ResourceLocation BAR_PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/white_progress");

    public ClientTFBossBar(UUID pId, Component pName, float pProgress, int pColor, BossEvent.BossBarOverlay pOverlay, boolean pDarkenScreen, boolean pBossMusic, boolean pWorldFog) {
        super(pId, pName, pProgress, BossEvent.BossBarColor.WHITE, pOverlay, pDarkenScreen, pBossMusic, pWorldFog);
        this.color = pColor;
    }

    public void setBarColor(int color) {
        this.color = color;
    }

    public long getSetTime() {
        return this.setTime;
    }

    public void setSetTime(long setTime) {
        this.setTime = setTime;
    }

    public void renderBossBar(GuiGraphics guiGraphics, int x, int y) {
        int i;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f), (float)1.0f);
        guiGraphics.blitSprite(BAR_BACKGROUND, 182, 5, 0, 0, x, y, 182, 5);
        if (this.overlay != BossEvent.BossBarOverlay.PROGRESS) {
            guiGraphics.blitSprite(BossHealthOverlay.OVERLAY_BACKGROUND_SPRITES[this.overlay.ordinal() - 1], 182, 5, 0, 0, x, y, 182, 5);
        }
        if ((i = Mth.lerpDiscrete((float)this.getProgress(), (int)0, (int)182)) > 0) {
            guiGraphics.blitSprite(BAR_PROGRESS, 182, 5, 0, 0, x, y, i, 5);
            if (this.overlay != BossEvent.BossBarOverlay.PROGRESS) {
                guiGraphics.blitSprite(BossHealthOverlay.OVERLAY_PROGRESS_SPRITES[this.overlay.ordinal() - 1], 182, 5, 0, 0, x, y, i, 5);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Component title = this.getName();
        int l = Minecraft.getInstance().font.width((FormattedText)title);
        int i1 = guiGraphics.guiWidth() / 2 - l / 2;
        int j1 = y - 9;
        guiGraphics.drawString(Minecraft.getInstance().font, title, i1, j1, 0xFFFFFF);
        RenderSystem.disableBlend();
    }
}

