/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import twilightforest.init.TFParticleType;

public abstract class BaseIceMob
extends Monster {
    public BaseIceMob(EntityType<? extends BaseIceMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public void aiStep() {
        if (!this.onGround() && this.getDeltaMovement().y() < 0.0) {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x(), motion.y() * 0.6, motion.z());
        }
        super.aiStep();
        if (this.level().isClientSide() && !this.isDeadOrDying()) {
            for (int i = 0; i < 3; ++i) {
                float px = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
                float py = this.getEyeHeight() + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f;
                float pz = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
                this.level().addParticle((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), this.xOld + (double)px, this.yOld + (double)py, this.zOld + (double)pz, 0.0, 0.0, 0.0);
                if (!this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) continue;
                if (this.random.nextInt(4) == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.xOld + (double)px, this.yOld + (double)py, this.zOld + (double)pz, 0.0, (double)0.1f, 0.0);
                }
                if (!this.random.nextBoolean()) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, this.xOld + (double)px, this.yOld + (double)py, this.zOld + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS) && this.tickCount % 20 == 0) {
            this.hurt(this.damageSources().onFire(), 1.0f);
        }
    }

    protected boolean canRide(Entity entity) {
        return false;
    }
}

