/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import twilightforest.entity.monster.BaseIceMob;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class IceCrystal
extends BaseIceMob {
    private int crystalAge;
    private int maxCrystalAge = -1;

    public IceCrystal(Level worldIn) {
        super((EntityType<? extends BaseIceMob>)((EntityType)TFEntities.ICE_CRYSTAL.get()), worldIn);
    }

    public IceCrystal(EntityType<? extends IceCrystal> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.ICE_CORE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.ICE_CORE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.ICE_CORE_DEATH.get();
    }

    public void setToDieIn30Seconds() {
        this.maxCrystalAge = 600;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            ++this.crystalAge;
            if (this.maxCrystalAge > 0 && this.crystalAge >= this.maxCrystalAge) {
                this.discard();
            }
        }
    }
}

