/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.entity.monster.DeathTome;
import twilightforest.entity.passive.Bighorn;
import twilightforest.entity.passive.DwarfRabbit;
import twilightforest.entity.passive.Squirrel;
import twilightforest.entity.passive.TinyBird;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFEntities;
import twilightforest.network.CreateMovingCicadaSoundPacket;

@EventBusSubscriber(modid="twilightforest")
public class MiscEvents {
    @SubscribeEvent
    public static void addPrey(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            EntityType type = mob.getType();
            if (type == EntityType.CAT) {
                mob.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, DwarfRabbit.class, true, null));
                mob.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, Squirrel.class, true, null));
                mob.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, TinyBird.class, true, null));
            } else if (type == EntityType.OCELOT) {
                mob.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal(mob, DwarfRabbit.class, true));
                mob.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal(mob, Squirrel.class, true));
                mob.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal(mob, TinyBird.class, true));
            } else if (type == EntityType.FOX) {
                mob.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal(mob, DwarfRabbit.class, true));
                mob.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal(mob, Squirrel.class, true));
            } else if (type == EntityType.WOLF) {
                mob.targetSelector.addGoal(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, DwarfRabbit.class, true, null));
                mob.targetSelector.addGoal(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, Squirrel.class, true, null));
                mob.targetSelector.addGoal(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, Bighorn.class, true, null));
            }
        }
    }

    @SubscribeEvent
    public static void armorChanged(LivingEquipmentChangeEvent event) {
        LivingEntity living = event.getEntity();
        if (ModList.get().isLoaded("curios") && CuriosCompat.isCurioEquipped(living, stack -> stack.is(TFBlocks.CICADA.asItem()))) {
            return;
        }
        if (living != null && !living.level().isClientSide() && event.getSlot() == EquipmentSlot.HEAD && event.getTo().is(TFBlocks.CICADA.asItem())) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)living, (CustomPacketPayload)new CreateMovingCicadaSoundPacket(living.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SpawnEggItem spawnEggItem;
        Player player = event.getEntity();
        ItemStack stack = player.getItemInHand(event.getHand());
        Item item = stack.getItem();
        if (!(item instanceof SpawnEggItem) || (spawnEggItem = (SpawnEggItem)item).getType(stack) != TFEntities.DEATH_TOME.get()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof LecternBlock && !((Boolean)state.getValue((Property)BlockStateProperties.HAS_BOOK)).booleanValue()) {
            event.setCanceled(true);
            level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DeathTome tome = (DeathTome)((EntityType)TFEntities.DEATH_TOME.get()).spawn(serverLevel, stack, player, pos.below(), MobSpawnType.SPAWN_EGG, true, false);
                if (tome != null) {
                    stack.consume(1, (LivingEntity)player);
                    serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
                    tome.setOnLectern(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void washOffCloth(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (!state.is(Blocks.WATER_CAULDRON) || (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) <= 0) {
            return;
        }
        if (event.getItemStack().has(TFDataComponents.EMPERORS_CLOTH)) {
            LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)event.getLevel(), (BlockPos)event.getPos());
            event.getItemStack().remove(TFDataComponents.EMPERORS_CLOTH);
            event.getEntity().awardStat(Stats.CLEAN_ARMOR);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

