/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.monster.Kobold;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.util.ProgressionStructure;

@EventBusSubscriber(modid="twilightforest")
public class ProgressionEvents {
    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        ServerLevel level;
        Player player = event.getPlayer();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel) || (level = (ServerLevel)levelAccessor).isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        if (ProgressionEvents.isBlockProtectedFromBreaking((BlockGetter)level, pos) && ProgressionEvents.isAreaProtected(level, player, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void placeBlock(BlockEvent.EntityPlaceEvent event) {
        ServerLevel level;
        Entity entity;
        block5: {
            block4: {
                entity = event.getEntity();
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block4;
                level = (ServerLevel)levelAccessor;
                if (entity instanceof Player) break block5;
            }
            return;
        }
        Player player = (Player)entity;
        BlockPos pos = event.getPos();
        if (ProgressionEvents.isBlockProtectedFromBreaking((BlockGetter)level, pos) && ProgressionEvents.isAreaProtected(level, player, pos)) {
            event.setCanceled(true);
            player.inventoryMenu.sendAllDataToRemote();
        }
    }

    @SubscribeEvent
    public static void placeMultiBlock(BlockEvent.EntityMultiPlaceEvent event) {
        ServerLevel level;
        Entity entity;
        block4: {
            block3: {
                entity = event.getEntity();
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block3;
                level = (ServerLevel)levelAccessor;
                if (entity instanceof Player) break block4;
            }
            return;
        }
        Player player = (Player)entity;
        for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
            BlockPos pos = snapshot.getPos();
            if (!ProgressionEvents.isBlockProtectedFromBreaking((BlockGetter)level, pos) || !ProgressionEvents.isAreaProtected(level, player, pos)) continue;
            event.setCanceled(true);
            player.inventoryMenu.sendAllDataToRemote();
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ProgressionEvents.isBlockProtectedFromInteraction((BlockGetter)level, event.getPos()) && ProgressionEvents.isAreaProtected(serverLevel, player, event.getPos())) {
                event.setUseBlock(TriState.FALSE);
            }
        }
    }

    private static boolean isBlockProtectedFromInteraction(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos).is(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(BlockGetter level, BlockPos pos) {
        return !level.getBlockState(pos).is(BlockTagGenerator.PROGRESSION_ALLOW_BREAKING);
    }

    private static boolean isAreaProtected(ServerLevel level, Player player, BlockPos pos) {
        ProgressionStructure structureHints;
        Structure structure;
        StructureStart structureStart;
        if (player.getAbilities().instabuild || player.isSpectator() || !LandmarkUtil.isProgressionEnforced((Level)level) || player instanceof FakePlayer) {
            return false;
        }
        Optional<StructureStart> struct = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)level, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (struct.isPresent() && (structureStart = struct.get()).getPieces().stream().anyMatch(structurePiece -> {
            TFStructureComponent tfStructureComponent;
            return structurePiece.getBoundingBox().isInside((Vec3i)pos) && (!(structurePiece instanceof TFStructureComponent) || (tfStructureComponent = (TFStructureComponent)structurePiece).isComponentProtected());
        }) && (structure = structureStart.getStructure()) instanceof ProgressionStructure && !(structureHints = (ProgressionStructure)structure).doesPlayerHaveRequiredAdvancements(player)) {
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            structureStart.getPieces().forEach(piece -> {
                if (piece.getBoundingBox().isInside((Vec3i)pos)) {
                    boxes.add(piece.getBoundingBox());
                }
            });
            ProgressionEvents.sendAreaProtectionPacket(level, pos, boxes);
            structureHints.trySpawnHintMonster((Level)level, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(ServerLevel level, BlockPos pos, List<BoundingBox> sbb) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)64.0, (CustomPacketPayload)new AreaProtectionPacket(sbb, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void livingAttack(LivingIncomingDamageEvent event) {
        LivingEntity living = event.getEntity();
        Level level = living.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (living instanceof Enemy && event.getSource().getEntity() instanceof Player && !(living instanceof Kobold) && ProgressionEvents.isAreaProtected(serverLevel, (Player)event.getSource().getEntity(), new BlockPos((Vec3i)living.blockPosition()))) {
                event.setCanceled(true);
            }
        }
    }
}

