/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.init.TFStructures;
import twilightforest.world.components.placements.AvoidLandmarkModifier;
import twilightforest.world.components.placements.ChunkBlanketingModifier;
import twilightforest.world.components.placements.ChunkCenterModifier;

public class TFPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PLACED_LAKE_LAVA = TFPlacedFeatures.registerKey("lava_lake");
    public static final ResourceKey<PlacedFeature> PLACED_LAKE_WATER = TFPlacedFeatures.registerKey("water_lake");
    public static final ResourceKey<PlacedFeature> PLACED_LAKE_FROZEN = TFPlacedFeatures.registerKey("frozen_lake");
    public static final ResourceKey<PlacedFeature> PLACED_DRUID_HUT = TFPlacedFeatures.registerKey("druid_hut");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_FERNS = TFPlacedFeatures.registerKey("dense_ferns");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_LARGE_FERNS = TFPlacedFeatures.registerKey("dense_large_ferns");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_LAKE_WATER = TFPlacedFeatures.registerKey("dense_water_lake");
    public static final ResourceKey<PlacedFeature> PLACED_GRAVEYARD = TFPlacedFeatures.registerKey("graveyard");
    public static final ResourceKey<PlacedFeature> PLACED_BIG_MUSHGLOOM = TFPlacedFeatures.registerKey("big_mushgloom");
    public static final ResourceKey<PlacedFeature> PLACED_FALLEN_LEAVES = TFPlacedFeatures.registerKey("fallen_leaves");
    public static final ResourceKey<PlacedFeature> PLACED_FIDDLEHEAD = TFPlacedFeatures.registerKey("fiddlehead");
    public static final ResourceKey<PlacedFeature> PLACED_FIRE_JET = TFPlacedFeatures.registerKey("fire_jet");
    public static final ResourceKey<PlacedFeature> PLACED_FOUNDATION = TFPlacedFeatures.registerKey("foundation");
    public static final ResourceKey<PlacedFeature> PLACED_GROVE_RUINS = TFPlacedFeatures.registerKey("grove_ruins");
    public static final ResourceKey<PlacedFeature> PLACED_HOLLOW_LOG = TFPlacedFeatures.registerKey("hollow_log");
    public static final ResourceKey<PlacedFeature> PLACED_HOLLOW_STUMP = TFPlacedFeatures.registerKey("hollow_stump");
    public static final ResourceKey<PlacedFeature> PLACED_HUGE_LILY_PAD = TFPlacedFeatures.registerKey("huge_lily_pad");
    public static final ResourceKey<PlacedFeature> PLACED_HUGE_WATER_LILY = TFPlacedFeatures.registerKey("huge_water_lily");
    public static final ResourceKey<PlacedFeature> PLACED_MAYAPPLE = TFPlacedFeatures.registerKey("mayapple");
    public static final ResourceKey<PlacedFeature> PLACED_MONOLITH = TFPlacedFeatures.registerKey("monolith");
    public static final ResourceKey<PlacedFeature> PLACED_MUSHGLOOM_CLUSTER = TFPlacedFeatures.registerKey("mushgloom_cluster");
    public static final ResourceKey<PlacedFeature> PLACED_SPARSE_MUSHGLOOMS = TFPlacedFeatures.registerKey("sparse_mushglooms");
    public static final ResourceKey<PlacedFeature> PLACED_MYCELIUM_BLOB = TFPlacedFeatures.registerKey("mycelium_blob");
    public static final ResourceKey<PlacedFeature> PLACED_OUTSIDE_STALAGMITE = TFPlacedFeatures.registerKey("outside_stalagmite");
    public static final ResourceKey<PlacedFeature> PLACED_PLANT_ROOTS = TFPlacedFeatures.registerKey("plant_roots");
    public static final ResourceKey<PlacedFeature> PLACED_PUMPKIN_LAMPPOST = TFPlacedFeatures.registerKey("pumpkin_lamppost");
    public static final ResourceKey<PlacedFeature> PLACED_SMOKER = TFPlacedFeatures.registerKey("smoker");
    public static final ResourceKey<PlacedFeature> PLACED_STONE_CIRCLE = TFPlacedFeatures.registerKey("stone_circle");
    public static final ResourceKey<PlacedFeature> PLACED_THORNS = TFPlacedFeatures.registerKey("thorns");
    public static final ResourceKey<PlacedFeature> PLACED_TORCH_BERRIES = TFPlacedFeatures.registerKey("torch_berries");
    public static final ResourceKey<PlacedFeature> PLACED_TROLL_ROOTS = TFPlacedFeatures.registerKey("troll_roots");
    public static final ResourceKey<PlacedFeature> PLACED_TROLL_MUSHGLOOMS = TFPlacedFeatures.registerKey("troll_mushglooms");
    public static final ResourceKey<PlacedFeature> PLACED_VANILLA_ROOTS = TFPlacedFeatures.registerKey("vanilla_roots");
    public static final ResourceKey<PlacedFeature> PLACED_WEBS = TFPlacedFeatures.registerKey("webs");
    public static final ResourceKey<PlacedFeature> PLACED_WOOD_ROOTS_SPREAD = TFPlacedFeatures.registerKey("wood_roots");
    public static final ResourceKey<PlacedFeature> PLACED_SNOW_UNDER_TREES = TFPlacedFeatures.registerKey("snow_under_trees");
    public static final ResourceKey<PlacedFeature> PLACED_ENCHANTED_FOREST_VINES = TFPlacedFeatures.registerKey("enchanted_forest_vines");
    public static final ResourceKey<PlacedFeature> PLACED_TF_OAK_FALLEN_LOG = TFPlacedFeatures.registerKey("tf_oak_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_FALLEN_LOG = TFPlacedFeatures.registerKey("canopy_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_MANGROVE_FALLEN_LOG = TFPlacedFeatures.registerKey("mangrove_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_SPRUCE_FALLEN_LOG = TFPlacedFeatures.registerKey("spruce_fallen_log");
    public static final ResourceKey<PlacedFeature> PLACED_SMALL_GRANITE = TFPlacedFeatures.registerKey("small_granite");
    public static final ResourceKey<PlacedFeature> PLACED_SMALL_DIORITE = TFPlacedFeatures.registerKey("small_diorite");
    public static final ResourceKey<PlacedFeature> PLACED_SMALL_ANDESITE = TFPlacedFeatures.registerKey("small_andesite");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_MUSHGLOOMS = TFPlacedFeatures.registerKey("dark_mushglooms");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_PUMPKINS = TFPlacedFeatures.registerKey("dark_pumpkins");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_GRASS = TFPlacedFeatures.registerKey("dark_grass");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_FERNS = TFPlacedFeatures.registerKey("dark_ferns");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_BROWN_MUSHROOMS = TFPlacedFeatures.registerKey("dark_brown_mushrooms");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_RED_MUSHROOMS = TFPlacedFeatures.registerKey("dark_red_mushrooms");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_DEAD_BUSHES = TFPlacedFeatures.registerKey("dark_dead_bushes");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_COAL_ORE = TFPlacedFeatures.registerKey("legacy_coal_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_IRON_ORE = TFPlacedFeatures.registerKey("legacy_iron_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_GOLD_ORE = TFPlacedFeatures.registerKey("legacy_gold_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_REDSTONE_ORE = TFPlacedFeatures.registerKey("legacy_redstone_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_DIAMOND_ORE = TFPlacedFeatures.registerKey("legacy_diamond_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_LAPIS_ORE = TFPlacedFeatures.registerKey("legacy_lapis_ore");
    public static final ResourceKey<PlacedFeature> PLACED_LEGACY_COPPER_ORE = TFPlacedFeatures.registerKey("legacy_copper_ore");
    public static final ResourceKey<PlacedFeature> PLACED_WELL_PLACER = TFPlacedFeatures.registerKey("well_placer");
    public static final ResourceKey<PlacedFeature> PLACED_LAMPPOST_PLACER = TFPlacedFeatures.registerKey("lamppost_placer");
    public static final ResourceKey<PlacedFeature> PLACED_DEFAULT_FALLEN_LOGS = TFPlacedFeatures.registerKey("default_fallen_logs");
    public static final ResourceKey<PlacedFeature> PLACED_FLOWER_PLACER = TFPlacedFeatures.registerKey("flower_placer");
    public static final ResourceKey<PlacedFeature> PLACED_FLOWER_PLACER_ALT = TFPlacedFeatures.registerKey("flower_placer_alt");
    public static final ResourceKey<PlacedFeature> PLACED_DEAD_CANOPY_TREE = TFPlacedFeatures.registerKey("tree/dead_canopy_tree");
    public static final ResourceKey<PlacedFeature> PLACED_MEGA_CANOPY_TREE = TFPlacedFeatures.registerKey("tree/mega_canopy_tree");
    public static final ResourceKey<PlacedFeature> PLACED_MANGROVE_TREE = TFPlacedFeatures.registerKey("tree/mangrove_tree");
    public static final ResourceKey<PlacedFeature> PLACED_TWILIGHT_OAK_TREE = TFPlacedFeatures.registerKey("tree/twilight_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_LARGE_TWILIGHT_OAK_TREE = TFPlacedFeatures.registerKey("tree/large_twilight_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FOREST_MEGA_OAK_TREE = TFPlacedFeatures.registerKey("tree/forest_mega_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_SAVANNAH_OAK_TREE = TFPlacedFeatures.registerKey("tree/savannah_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_SAVANNAH_MEGA_OAK_TREE = TFPlacedFeatures.registerKey("tree/savannah_mega_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_SWAMPY_OAK_TREE = TFPlacedFeatures.registerKey("tree/swampy_oak_tree");
    public static final ResourceKey<PlacedFeature> PLACED_DARKWOOD_TREE = TFPlacedFeatures.registerKey("tree/darkwood_tree");
    public static final ResourceKey<PlacedFeature> PLACED_OAK_BUSH = TFPlacedFeatures.registerKey("tree/oak_bush");
    public static final ResourceKey<PlacedFeature> PLACED_OAK_BUSH_DENSE = TFPlacedFeatures.registerKey("tree/oak_bush_dense");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_TREES = TFPlacedFeatures.registerKey("tree/selector/canopy_trees");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_CANOPY_TREES = TFPlacedFeatures.registerKey("tree/selector/dense_canopy_trees");
    public static final ResourceKey<PlacedFeature> PLACED_FIREFLY_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/firefly_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/dark_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_DARK_FOREST_TREE_MIX = TFPlacedFeatures.registerKey("tree/selector/dark_forest_tree_mix");
    public static final ResourceKey<PlacedFeature> PLACED_HIGHLANDS_TREES = TFPlacedFeatures.registerKey("tree/selector/highlands_trees");
    public static final ResourceKey<PlacedFeature> PLACED_ENCHANTED_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/enchanted_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_SNOWY_FOREST_TREES = TFPlacedFeatures.registerKey("tree/selector/snowy_forest_trees");
    public static final ResourceKey<PlacedFeature> PLACED_VANILLA_TF_TREES = TFPlacedFeatures.registerKey("tree/selector/vanilla_trees");
    public static final ResourceKey<PlacedFeature> PLACED_VANILLA_TF_BIG_MUSH = TFPlacedFeatures.registerKey("tree/selector/vanilla_mushrooms");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_MUSHROOMS_SPARSE = TFPlacedFeatures.registerKey("mushroom/canopy_mushrooms_sparse");
    public static final ResourceKey<PlacedFeature> PLACED_CANOPY_MUSHROOMS_DENSE = TFPlacedFeatures.registerKey("mushroom/canopy_mushrooms_dense");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_FOREST = TFPlacedFeatures.registerKey("patch_grass_forest");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_BADLANDS = TFPlacedFeatures.registerKey("patch_grass_badlands");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_SAVANNA = TFPlacedFeatures.registerKey("patch_grass_savanna");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_TAIGA_2 = TFPlacedFeatures.registerKey("patch_grass_taiga_2");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_TAIGA = TFPlacedFeatures.registerKey("patch_grass_taiga");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_JUNGLE = TFPlacedFeatures.registerKey("patch_grass_jungle");
    public static final ResourceKey<PlacedFeature> PATCH_TALL_GRASS = PlacementUtils.createKey((String)"patch_tall_grass");
    public static final ResourceKey<PlacedFeature> PATCH_LARGE_FERN = PlacementUtils.createKey((String)"patch_large_fern");
    public static final ResourceKey<PlacedFeature> FLOWER_FOREST_FLOWERS = PlacementUtils.createKey((String)"flower_forest_flowers");

    private static List<PlacementModifier> tfTreeCheckArea(BlockState sapling) {
        return TFPlacedFeatures.tfTreeCheckArea(sapling, (HolderSet<Structure>)HolderSet.empty());
    }

    private static List<PlacementModifier> tfTreeCheckArea(BlockState sapling, HolderSet<Structure> structuresAllowed) {
        return List.of(InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, AvoidLandmarkModifier.checkSurface(structuresAllowed), PlacementUtils.filteredByBlockSurvival((Block)sapling.getBlock()), BiomeFilter.biome());
    }

    private static List<PlacementModifier> tfTreeCheckArea(PlacementModifier count, BlockState sapling) {
        return TFPlacedFeatures.tfTreeCheckArea(count, sapling, (HolderSet<Structure>)HolderSet.empty());
    }

    private static List<PlacementModifier> tfTreeCheckArea(PlacementModifier count, BlockState sapling, HolderSet<Structure> structuresAllowed) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.spread(), (Object)SurfaceWaterDepthFilter.forMaxDepth((int)0), (Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, (Object)((Object)AvoidLandmarkModifier.checkSurface(structuresAllowed)), (Object)PlacementUtils.filteredByBlockSurvival((Block)sapling.getBlock()), (Object)BiomeFilter.biome());
    }

    private static List<PlacementModifier> darkForestTreeCheck(PlacementModifier count) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.spread(), (Object)SurfaceWaterDepthFilter.forMaxDepth((int)0), (Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, (Object)((Object)new AvoidLandmarkModifier(true, false, 10, (HolderSet<Structure>)HolderSet.empty())), (Object)BiomeFilter.biome());
    }

    private static ImmutableList.Builder<PlacementModifier> tfFeatureCheckArea(AvoidLandmarkModifier filter, int rarity) {
        return ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, filter, BiomeFilter.biome()});
    }

    private static ImmutableList.Builder<PlacementModifier> tfFeatureCheckArea(AvoidLandmarkModifier filter, int rarity, PlacementModifier ... extra) {
        return ImmutableList.builder().add((Object[])extra).add((Object[])new PlacementModifier[]{filter, RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    private static ImmutableList.Builder<PlacementModifier> hollowLog(AvoidLandmarkModifier filter) {
        return ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)40), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, filter, BiomeFilter.biome()});
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        AvoidLandmarkModifier avoidLichTower = AvoidLandmarkModifier.checkVegetation();
        Holder.Reference lichTowerHolder = context.lookup(Registries.STRUCTURE).getOrThrow(TFStructures.LICH_TOWER);
        HolderSet.Direct allowLichTower = HolderSet.direct((Holder[])new Holder[]{lichTowerHolder});
        context.register(PLACED_LAKE_LAVA, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LAKE_LAVA), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 10).build()));
        context.register(PLACED_LAKE_WATER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LAKE_WATER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 32).build()));
        context.register(PLACED_LAKE_FROZEN, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LAKE_FROZEN), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 4).build()));
        context.register(PLACED_DRUID_HUT, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DRUID_HUT), (List)TFPlacedFeatures.tfFeatureCheckArea(new AvoidLandmarkModifier(true, true, 16, (HolderSet<Structure>)HolderSet.empty()), 105).build()));
        context.register(PLACED_DENSE_FERNS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DENSE_FERNS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.countExtra((int)3, (float)0.5f, (int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), avoidLichTower}).build()));
        context.register(PLACED_DENSE_LARGE_FERNS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DENSE_LARGE_FERNS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), avoidLichTower}).build()));
        context.register(PLACED_DENSE_LAKE_WATER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LAKE_WATER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 4).build()));
        context.register(PLACED_GRAVEYARD, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.GRAVEYARD), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 70).build()));
        context.register(PLACED_BIG_MUSHGLOOM, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.BIG_MUSHGLOOM), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build()));
        context.register(PLACED_FALLEN_LEAVES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FALLEN_LEAVES), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build()));
        context.register(PLACED_FIDDLEHEAD, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FIDDLEHEAD), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_FIRE_JET, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FIRE_JET), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, InSquarePlacement.spread(), BiomeFilter.biome()}).build()));
        context.register(PLACED_FOUNDATION, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FOUNDATION), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 90).build()));
        context.register(PLACED_GROVE_RUINS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.GROVE_RUINS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 110).build()));
        context.register(PLACED_HOLLOW_LOG, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.HOLLOW_LOG), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 85).build()));
        context.register(PLACED_HOLLOW_STUMP, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.HOLLOW_STUMP), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 80).build()));
        context.register(PLACED_HUGE_LILY_PAD, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.HUGE_LILY_PAD), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, RarityFilter.onAverageOnceEvery((int)20), InSquarePlacement.spread(), CountPlacement.of((int)10), BiomeFilter.biome()}).build()));
        context.register(PLACED_HUGE_WATER_LILY, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.HUGE_WATER_LILY), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, RarityFilter.onAverageOnceEvery((int)25), InSquarePlacement.spread(), CountPlacement.of((int)5), BiomeFilter.biome()}).build()));
        context.register(PLACED_MAYAPPLE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MAYAPPLE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), avoidLichTower}).build()));
        context.register(PLACED_MONOLITH, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MONOLITH), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 90).build()));
        context.register(PLACED_MUSHGLOOM_CLUSTER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MUSHGLOOM_CLUSTER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.filteredByBlockSurvival((Block)((Block)TFBlocks.MUSHGLOOM.get())), BiomeFilter.biome(), avoidLichTower}).build()));
        context.register(PLACED_SPARSE_MUSHGLOOMS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MUSHGLOOM_CLUSTER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, RarityFilter.onAverageOnceEvery((int)15), InSquarePlacement.spread(), PlacementUtils.filteredByBlockSurvival((Block)((Block)TFBlocks.MUSHGLOOM.get())), BiomeFilter.biome()}).build()));
        context.register(PLACED_MYCELIUM_BLOB, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MYCELIUM_BLOB), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 3).build()));
        context.register(PLACED_OUTSIDE_STALAGMITE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.OUTSIDE_STALAGMITE), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 77).build()));
        context.register(PLACED_PLANT_ROOTS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.PLANT_ROOTS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 1, new PlacementModifier[]{CountPlacement.of((int)4), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)10))}).build()));
        context.register(PLACED_PUMPKIN_LAMPPOST, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.PUMPKIN_LAMPPOST), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 10).build()));
        context.register(PLACED_SMOKER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SMOKER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, InSquarePlacement.spread(), BiomeFilter.biome()}).build()));
        context.register(PLACED_STONE_CIRCLE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.STONE_CIRCLE), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 105).build()));
        context.register(PLACED_THORNS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.THORNS), (List)ImmutableList.builder().add((Object)ChunkBlanketingModifier.addThorns((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(TFBiomes.THORNLANDS)}))).build()));
        context.register(PLACED_TORCH_BERRIES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.TORCH_BERRIES), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)60)), CountPlacement.of((int)8), InSquarePlacement.spread(), AvoidLandmarkModifier.checkUnderground(), BiomeFilter.biome()}).build()));
        context.register(PLACED_TROLL_ROOTS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.TROLL_ROOTS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, CountOnEveryLayerPlacement.of((int)12), BiomeFilter.biome()}).build()));
        context.register(PLACED_TROLL_MUSHGLOOMS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.TROLL_MUSHGLOOMS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)15)), CountPlacement.of((int)3), AvoidLandmarkModifier.checkUnderground(), BiomeFilter.biome()}).build()));
        context.register(PLACED_VANILLA_ROOTS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.VANILLA_ROOTS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 1, new PlacementModifier[]{CountPlacement.of((int)16), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)0)), PlacementUtils.filteredByBlockSurvival((Block)((Block)TFBlocks.TORCHBERRY_PLANT.get()))}).build()));
        context.register(PLACED_WEBS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.WEBS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, CountPlacement.of((int)60), InSquarePlacement.spread(), BiomeFilter.biome()}).build()));
        context.register(PLACED_WOOD_ROOTS_SPREAD, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.WOOD_ROOTS_SPREAD), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 40, new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)0))}).build()));
        context.register(PLACED_SNOW_UNDER_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SNOW_UNDER_TREES), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_TF_OAK_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.TF_OAK_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.register(PLACED_CANOPY_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.CANOPY_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.register(PLACED_MANGROVE_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MANGROVE_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.register(PLACED_SPRUCE_FALLEN_LOG, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SPRUCE_FALLEN_LOG), (List)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface()).build()));
        context.register(PLACED_SMALL_GRANITE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SMALL_GRANITE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)64)), RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), CountPlacement.of((int)5), BiomeFilter.biome()}).build()));
        context.register(PLACED_SMALL_DIORITE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SMALL_DIORITE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)64)), RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), CountPlacement.of((int)5), BiomeFilter.biome()}).build()));
        context.register(PLACED_SMALL_ANDESITE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SMALL_ANDESITE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)64)), RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), CountPlacement.of((int)5), BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_PUMPKINS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_PUMPKINS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)30), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_GRASS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_GRASS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{CountPlacement.of((int)20), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_FERNS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_FERNS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_MUSHGLOOMS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_MUSHGLOOMS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_BROWN_MUSHROOMS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_BROWN_MUSHROOMS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_RED_MUSHROOMS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_RED_MUSHROOMS), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_DARK_DEAD_BUSHES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_DEAD_BUSHES), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()}).build()));
        context.register(PLACED_ENCHANTED_FOREST_VINES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.ENCHANTED_FOREST_VINES), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_COAL_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_COAL_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)127)), InSquarePlacement.spread(), CountPlacement.of((int)20), BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_IRON_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_IRON_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)63)), InSquarePlacement.spread(), CountPlacement.of((int)20), BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_GOLD_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_GOLD_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)31)), InSquarePlacement.spread(), CountPlacement.of((int)2), BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_REDSTONE_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_REDSTONE_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)15)), InSquarePlacement.spread(), CountPlacement.of((int)8), BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_DIAMOND_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_DIAMOND_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)15)), InSquarePlacement.spread(), BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_LAPIS_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_LAPIS_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)30)), InSquarePlacement.spread(), CountPlacement.of((int)2), BiomeFilter.biome()}).build()));
        context.register(PLACED_LEGACY_COPPER_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LEGACY_COPPER_ORE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)96)), InSquarePlacement.spread(), CountPlacement.of((int)6), BiomeFilter.biome()}).build()));
        context.register(PLACED_WELL_PLACER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.WELL_PLACER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 80).build()));
        context.register(PLACED_LAMPPOST_PLACER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LAMPPOST_PLACER), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 2).build()));
        context.register(PLACED_DEFAULT_FALLEN_LOGS, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DEFAULT_FALLEN_LOGS), (List)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 40).build()));
        context.register(PLACED_FLOWER_PLACER, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FLOWER_PLACER), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, CountPlacement.of((int)3), InSquarePlacement.spread(), RarityFilter.onAverageOnceEvery((int)2), BiomeFilter.biome(), avoidLichTower}).build()));
        context.register(PLACED_FLOWER_PLACER_ALT, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FLOWER_PLACER_ALT), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, CountPlacement.of((int)3), InSquarePlacement.spread(), RarityFilter.onAverageOnceEvery((int)2), BiomeFilter.biome(), avoidLichTower}).build()));
        context.register(PLACED_DEAD_CANOPY_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DEAD_CANOPY_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_MEGA_CANOPY_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MEGA_CANOPY_TREE), (List)ImmutableList.of((Object)((Object)ChunkCenterModifier.center()), (Object)RarityFilter.onAverageOnceEvery((int)20), (Object)SurfaceWaterDepthFilter.forMaxDepth((int)0), (Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, (Object)((Object)AvoidLandmarkModifier.checkSurface()), (Object)PlacementUtils.filteredByBlockSurvival((Block)((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState().getBlock()), (Object)BiomeFilter.biome())));
        context.register(PLACED_MANGROVE_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.MANGROVE_TREE), List.of(PlacementUtils.countExtra((int)3, (float)0.1f, (int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)6), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, AvoidLandmarkModifier.checkSurface(), PlacementUtils.filteredByBlockSurvival((Block)((Block)TFBlocks.MANGROVE_SAPLING.get())), BiomeFilter.biome(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(PLACED_TWILIGHT_OAK_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.TWILIGHT_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_LARGE_TWILIGHT_OAK_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.LARGE_TWILIGHT_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_FOREST_MEGA_OAK_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FOREST_MEGA_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)7, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState())));
        context.register(PLACED_SAVANNAH_MEGA_OAK_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SAVANNAH_MEGA_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)0, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState())));
        context.register(PLACED_SAVANNAH_OAK_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.TWILIGHT_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_SWAMPY_OAK_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SWAMPY_OAK_TREE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)4, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState())));
        context.register(PLACED_OAK_BUSH, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.OAK_BUSH), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)1, (float)0.33333334f, (int)1), Blocks.OAK_SAPLING.defaultBlockState())));
        context.register(PLACED_OAK_BUSH_DENSE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.OAK_BUSH), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)2, (float)0.33333334f, (int)2), Blocks.OAK_SAPLING.defaultBlockState())));
        context.register(PLACED_DARKWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARKWOOD_TREE), List.of(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, new AvoidLandmarkModifier(true, false, 16, (HolderSet<Structure>)HolderSet.empty()), PlacementUtils.filteredByBlockSurvival((Block)((Block)TFBlocks.DARKWOOD_SAPLING.get())), BiomeFilter.biome())));
        context.register(PLACED_CANOPY_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.CANOPY_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)7, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_DENSE_CANOPY_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DENSE_CANOPY_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_FIREFLY_FOREST_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.FIREFLY_FOREST_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)3, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_DARK_FOREST_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARKWOOD_TREE), TFPlacedFeatures.darkForestTreeCheck(PlacementUtils.countExtra((int)8, (float)0.1f, (int)1))));
        context.register(PLACED_DARK_FOREST_TREE_MIX, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.DARK_FOREST_TREES), TFPlacedFeatures.darkForestTreeCheck(PlacementUtils.countExtra((int)3, (float)0.1f, (int)1))));
        context.register(PLACED_HIGHLANDS_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.HIGHLANDS_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)3, (float)0.1f, (int)1), Blocks.SPRUCE_SAPLING.defaultBlockState())));
        context.register(PLACED_ENCHANTED_FOREST_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.ENCHANTED_FOREST_TREES), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.RAINBOW_OAK_SAPLING.get()).defaultBlockState())));
        context.register(PLACED_SNOWY_FOREST_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.SNOWY_FOREST_TREES), List.of(PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, AvoidLandmarkModifier.checkSurface(), EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.POWDER_SNOW})), (int)8), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.SNOW_BLOCK, Blocks.POWDER_SNOW})), BiomeFilter.biome())));
        context.register(PLACED_VANILLA_TF_TREES, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.VANILLA_TF_TREES), TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).defaultBlockState(), (HolderSet<Structure>)allowLichTower)));
        context.register(PLACED_VANILLA_TF_BIG_MUSH, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.VANILLA_TF_BIG_MUSH), TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState())));
        context.register(PLACED_CANOPY_MUSHROOMS_SPARSE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.CANOPY_MUSHROOMS_SPARSE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)3, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState())));
        context.register(PLACED_CANOPY_MUSHROOMS_DENSE, (Object)new PlacedFeature((Holder)features.getOrThrow(TFConfiguredFeatures.CANOPY_MUSHROOMS_DENSE), TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).defaultBlockState())));
        List<AvoidLandmarkModifier> avoidLichTowerList = List.of(avoidLichTower);
        Holder.Reference grassConfig = features.getOrThrow(VegetationFeatures.PATCH_GRASS);
        PlacementUtils.register(context, PATCH_GRASS_FOREST, (Holder)grassConfig, (List)ConcatenatedListView.of((List[])new List[]{VegetationPlacements.worldSurfaceSquaredWithCount((int)2), avoidLichTowerList}));
        PlacementUtils.register(context, PATCH_GRASS_BADLANDS, (Holder)grassConfig, (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), avoidLichTower});
        PlacementUtils.register(context, PATCH_GRASS_SAVANNA, (Holder)grassConfig, (List)ConcatenatedListView.of((List[])new List[]{VegetationPlacements.worldSurfaceSquaredWithCount((int)20), avoidLichTowerList}));
        Holder.Reference taigaGrassConfig = features.getOrThrow(VegetationFeatures.PATCH_TAIGA_GRASS);
        PlacementUtils.register(context, PATCH_GRASS_TAIGA_2, (Holder)taigaGrassConfig, (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), avoidLichTower});
        PlacementUtils.register(context, PATCH_GRASS_TAIGA, (Holder)taigaGrassConfig, (List)ConcatenatedListView.of((List[])new List[]{VegetationPlacements.worldSurfaceSquaredWithCount((int)7), avoidLichTowerList}));
        Holder.Reference jungleGrassConfig = features.getOrThrow(VegetationFeatures.PATCH_GRASS_JUNGLE);
        PlacementUtils.register(context, PATCH_GRASS_JUNGLE, (Holder)jungleGrassConfig, (List)ConcatenatedListView.of((List[])new List[]{VegetationPlacements.worldSurfaceSquaredWithCount((int)25), avoidLichTowerList}));
        Holder.Reference tallGrassConfig = features.getOrThrow(VegetationFeatures.PATCH_TALL_GRASS);
        PlacementUtils.register(context, PATCH_TALL_GRASS, (Holder)tallGrassConfig, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), avoidLichTower});
        Holder.Reference fernConfig = features.getOrThrow(VegetationFeatures.PATCH_LARGE_FERN);
        PlacementUtils.register(context, PATCH_LARGE_FERN, (Holder)fernConfig, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), avoidLichTower});
        Holder.Reference forestFlowersConfig = features.getOrThrow(VegetationFeatures.FOREST_FLOWERS);
        PlacementUtils.register(context, FLOWER_FOREST_FLOWERS, (Holder)forestFlowersConfig, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)7), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, CountPlacement.of((IntProvider)ClampedInt.of((IntProvider)UniformInt.of((int)-1, (int)3), (int)0, (int)3)), BiomeFilter.biome(), avoidLichTower});
    }
}

