/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructures;
import twilightforest.world.components.structures.placements.AvoidLandmarkGridPlacement;
import twilightforest.world.components.structures.placements.LandmarkGridPlacement;

public class TFStructureSets {
    public static final ResourceKey<StructureSet> FALLEN_TRUNK = TFStructureSets.registerKey("fallen_trunk");
    public static final ResourceKey<StructureSet> HOLLOW_TREE = TFStructureSets.registerKey("hollow_tree");
    public static final ResourceKey<StructureSet> HEDGE_MAZE = TFStructureSets.registerKey("hedge_maze");
    public static final ResourceKey<StructureSet> QUEST_GROVE = TFStructureSets.registerKey("quest_grove");
    public static final ResourceKey<StructureSet> HOLLOW_HILL_SMALL = TFStructureSets.registerKey("small_hollow_hill");
    public static final ResourceKey<StructureSet> HOLLOW_HILL_MEDIUM = TFStructureSets.registerKey("medium_hollow_hill");
    public static final ResourceKey<StructureSet> HOLLOW_HILL_LARGE = TFStructureSets.registerKey("large_hollow_hill");
    public static final ResourceKey<StructureSet> NAGA_COURTYARD = TFStructureSets.registerKey("naga_courtyard");
    public static final ResourceKey<StructureSet> LICH_TOWER = TFStructureSets.registerKey("lich_tower");
    public static final ResourceKey<StructureSet> LABYRINTH = TFStructureSets.registerKey("labyrinth");
    public static final ResourceKey<StructureSet> HYDRA_LAIR = TFStructureSets.registerKey("hydra_lair");
    public static final ResourceKey<StructureSet> KNIGHT_STRONGHOLD = TFStructureSets.registerKey("knight_stronghold");
    public static final ResourceKey<StructureSet> DARK_TOWER = TFStructureSets.registerKey("dark_tower");
    public static final ResourceKey<StructureSet> YETI_CAVE = TFStructureSets.registerKey("yeti_cave");
    public static final ResourceKey<StructureSet> AURORA_PALACE = TFStructureSets.registerKey("aurora_palace");
    public static final ResourceKey<StructureSet> TROLL_CAVE = TFStructureSets.registerKey("troll_cave");
    public static final ResourceKey<StructureSet> GIANT_HOUSE = TFStructureSets.registerKey("giant_house");
    public static final ResourceKey<StructureSet> FINAL_CASTLE = TFStructureSets.registerKey("final_castle");
    public static final ResourceKey<StructureSet> MUSHROOM_TOWER = TFStructureSets.registerKey("mushroom_tower");
    public static final ResourceKey<StructureSet> QUEST_ISLAND = TFStructureSets.registerKey("quest_island");
    public static final ResourceKey<StructureSet> DRUID_GROVE = TFStructureSets.registerKey("druid_grove");
    public static final ResourceKey<StructureSet> FLOATING_RUINS = TFStructureSets.registerKey("floating_ruins");
    public static final ResourceKey<StructureSet> WORLD_TREE = TFStructureSets.registerKey("world_tree");

    private static ResourceKey<StructureSet> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        HolderGetter structureSets = context.lookup(Registries.STRUCTURE_SET);
        List<StructureSet.StructureSelectionEntry> hollowTrees = List.of(new StructureSet.StructureSelectionEntry((Holder)structures.getOrThrow(TFStructures.HOLLOW_TREE), 1), new StructureSet.StructureSelectionEntry((Holder)structures.getOrThrow(TFStructures.SWAMP_HOLLOW_TREE), 1));
        context.register(FALLEN_TRUNK, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.FALLEN_TRUNK), (StructurePlacement)new AvoidLandmarkGridPlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 0.8f, 1275623845, Optional.of(new StructurePlacement.ExclusionZone((Holder)structureSets.getOrThrow(HOLLOW_TREE), 1)), 7, 5, RandomSpreadType.TRIANGULAR)));
        context.register(HOLLOW_TREE, (Object)new StructureSet(hollowTrees, (StructurePlacement)new AvoidLandmarkGridPlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 0.5f, 34481210, Optional.empty(), 7, 5, RandomSpreadType.TRIANGULAR)));
        context.register(HEDGE_MAZE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.HEDGE_MAZE), (StructurePlacement)new LandmarkGridPlacement(Optional.of(TFStructures.HEDGE_MAZE))));
        context.register(HOLLOW_HILL_SMALL, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.HOLLOW_HILL_SMALL), (StructurePlacement)new LandmarkGridPlacement(Optional.of(TFStructures.HOLLOW_HILL_SMALL))));
        context.register(HOLLOW_HILL_MEDIUM, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.HOLLOW_HILL_MEDIUM), (StructurePlacement)new LandmarkGridPlacement(Optional.of(TFStructures.HOLLOW_HILL_MEDIUM))));
        context.register(HOLLOW_HILL_LARGE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.HOLLOW_HILL_LARGE), (StructurePlacement)new LandmarkGridPlacement(Optional.of(TFStructures.HOLLOW_HILL_LARGE))));
        context.register(NAGA_COURTYARD, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.NAGA_COURTYARD), (StructurePlacement)new LandmarkGridPlacement(Optional.of(TFStructures.NAGA_COURTYARD))));
        context.register(LICH_TOWER, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.LICH_TOWER), (StructurePlacement)new LandmarkGridPlacement(Optional.of(TFStructures.LICH_TOWER))));
        context.register(QUEST_GROVE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.QUEST_GROVE), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(LABYRINTH, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.LABYRINTH), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(HYDRA_LAIR, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.HYDRA_LAIR), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(KNIGHT_STRONGHOLD, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.KNIGHT_STRONGHOLD), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(DARK_TOWER, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.DARK_TOWER), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(YETI_CAVE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.YETI_CAVE), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(AURORA_PALACE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.AURORA_PALACE), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(TROLL_CAVE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.TROLL_CAVE), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(GIANT_HOUSE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.GIANT_HOUSE), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
        context.register(FINAL_CASTLE, (Object)new StructureSet((Holder)structures.getOrThrow(TFStructures.FINAL_CASTLE), (StructurePlacement)LandmarkGridPlacement.forceStructureForCenters()));
    }
}

