/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import twilightforest.TwilightForestMod;
import twilightforest.components.entity.MultiplayerInclusivityAttachment;
import twilightforest.config.TFConfig;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFLoot;

public class MultiplayerBasedAdditionLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<MultiplayerBasedAdditionLootFunction> CODEC = RecordCodecBuilder.mapCodec(p_298131_ -> MultiplayerBasedAdditionLootFunction.commonFields((RecordCodecBuilder.Instance)p_298131_).and((App)NumberProviders.CODEC.fieldOf("extra_count_per_player").forGetter(o -> o.value)).apply((Applicative)p_298131_, MultiplayerBasedAdditionLootFunction::new));
    private final NumberProvider value;

    public MultiplayerBasedAdditionLootFunction(List<LootItemCondition> predicates, NumberProvider value) {
        super(predicates);
        this.value = value;
    }

    public static Builder addForAllParticipatingPlayers(NumberProvider additionPerPlayer) {
        return new Builder(additionPerPlayer);
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)TFLoot.MULTIPLAYER_MULTIPLIER.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        int qualifiedPlayers;
        if (TFConfig.multiplayerFightAdjuster.adjustsLootRolls() && context.hasParam(LootContextParams.THIS_ENTITY) && ((Entity)context.getParam(LootContextParams.THIS_ENTITY)).hasData(TFDataAttachments.MULTIPLAYER_FIGHT) && (qualifiedPlayers = ((MultiplayerInclusivityAttachment)((Entity)context.getParam(LootContextParams.THIS_ENTITY)).getData(TFDataAttachments.MULTIPLAYER_FIGHT)).getQualifiedPlayers().size()) > 1) {
            int participatingPlayers = qualifiedPlayers - 1;
            int extraItems = this.value.getInt(context) * participatingPlayers;
            stack.setCount(Mth.clamp((int)(stack.getCount() + extraItems), (int)0, (int)stack.getMaxStackSize()));
            TwilightForestMod.LOGGER.debug("{} extra players participated in a fight against {}, dropping {} extra {} for a total of {}.", (Object)participatingPlayers, (Object)((Entity)context.getParam(LootContextParams.THIS_ENTITY)).getType().getDescription().getString(), (Object)extraItems, (Object)stack.getItem().getDescription().getString(), (Object)stack.getCount());
        }
        return stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider count;

        public Builder(NumberProvider pLootingMultiplier) {
            this.count = pLootingMultiplier;
        }

        protected Builder getThis() {
            return this;
        }

        public MultiplayerBasedAdditionLootFunction build() {
            return new MultiplayerBasedAdditionLootFunction(this.getConditions(), this.count);
        }
    }
}

