/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.item.MazeMapItem;
import twilightforest.item.mapdata.TFMazeMapData;

public record MazeMapPacket(ClientboundMapItemDataPacket inner, boolean ore, int yCenter) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MazeMapPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("maze_map"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MazeMapPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ClientboundMapItemDataPacket.STREAM_CODEC, MazeMapPacket::inner, (StreamCodec)ByteBufCodecs.BOOL, MazeMapPacket::ore, (StreamCodec)ByteBufCodecs.INT, MazeMapPacket::yCenter, MazeMapPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final MazeMapPacket message, final IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Level level = ctx.player().level();
                    MapRenderer mapitemrenderer = Minecraft.getInstance().gameRenderer.getMapRenderer();
                    String s = MazeMapItem.getMapName(message.inner().mapId().id());
                    TFMazeMapData mapdata = TFMazeMapData.getMazeMapData(level, s);
                    if (mapdata == null) {
                        mapdata = new TFMazeMapData(0, 0, message.inner().scale(), false, false, message.inner().locked(), (ResourceKey<Level>)level.dimension());
                        TFMazeMapData.registerMazeMapData(level, mapdata, s);
                    }
                    mapdata.ore = message.ore();
                    mapdata.yCenter = message.yCenter();
                    message.inner().applyToMap((MapItemSavedData)mapdata);
                    mapitemrenderer.update(message.inner().mapId(), (MapItemSavedData)mapdata);
                }
            });
        }
    }
}

