/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.init.TFDimension;
import twilightforest.util.Codecs;

public record StructureProtectionPacket(Optional<List<Pair<BoundingBox, Boolean>>> boxes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StructureProtectionPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("change_protection_renderer"));
    public static final StreamCodec<RegistryFriendlyByteBuf, StructureProtectionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)Codecs.listOf(Codecs.BOX_AND_FLAG_STREAM_CODEC).apply(ByteBufCodecs::optional), StructureProtectionPacket::boxes, StructureProtectionPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StructureProtectionPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            DimensionSpecialEffects info = DimensionSpecialEffectsManager.getForType((ResourceLocation)TFDimension.DIMENSION_RENDERER);
            if (info instanceof TwilightForestRenderInfo) {
                TFWeatherRenderer.setProtectedBoxes(message.boxes().orElse(null));
            }
        });
    }
}

