/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;

public record UpdateDeathTimePacket(int entityID, int deathTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateDeathTimePacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("death_time_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateDeathTimePacket> STREAM_CODEC = CustomPacketPayload.codec(UpdateDeathTimePacket::write, UpdateDeathTimePacket::read);

    public static UpdateDeathTimePacket read(RegistryFriendlyByteBuf buf) {
        return new UpdateDeathTimePacket(buf.readInt(), buf.readInt());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.writeInt(this.deathTime());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateDeathTimePacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Entity patt0$temp;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (patt0$temp = Minecraft.getInstance().level.getEntity(message.entityID)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                living.deathTime = message.deathTime();
            }
        });
    }
}

