/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectSortedMap;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public final class Codecs {
    public static final Codec<BlockPos> STRING_POS = Codec.STRING.comapFlatMap(Codecs::parseString2BlockPos, Vec3i::toShortString);
    public static final Codec<Direction> ONLY_HORIZONTAL = Direction.CODEC.comapFlatMap(direction -> direction.getAxis() != Direction.Axis.Y ? DataResult.success((Object)direction) : DataResult.error(() -> "Horizontal direction only!", (Object)direction), Function.identity());
    public static final Codec<Float> FLOAT_STRING = Codec.STRING.comapFlatMap(Codecs::parseString2Float, f -> Float.toString(f.floatValue()));
    public static final Codec<Double> DOUBLE_STRING = Codec.STRING.comapFlatMap(Codecs::parseString2Double, f -> Double.toString(f));
    public static final StreamCodec<ByteBuf, BoundingBox> BOX_STREAM_CODEC = new StreamCodec<ByteBuf, BoundingBox>(){

        public BoundingBox decode(ByteBuf buf) {
            return new BoundingBox(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        }

        public void encode(ByteBuf buf, BoundingBox box) {
            buf.writeInt(box.minX());
            buf.writeInt(box.minY());
            buf.writeInt(box.minZ());
            buf.writeInt(box.maxX());
            buf.writeInt(box.maxY());
            buf.writeInt(box.maxZ());
        }
    };
    public static final Codec<MapDecoration> DECORATION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.MAP_DECORATION_TYPE.holderByNameCodec().fieldOf("type").forGetter(MapDecoration::type), (App)Codec.BYTE.fieldOf("x").forGetter(MapDecoration::x), (App)Codec.BYTE.fieldOf("y").forGetter(MapDecoration::y), (App)Codec.BYTE.fieldOf("rot").forGetter(MapDecoration::rot), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(MapDecoration::name)).apply((Applicative)instance, MapDecoration::new));
    public static final MapCodec<MapColor> COLOR_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(o -> o.id), (App)Codec.INT.fieldOf("color").forGetter(o -> o.col)).apply((Applicative)instance, MapColor::new)).validate(Codecs::validateMapColor);
    public static final Codec<GameProfile> SIMPLE_GAME_PROFILE = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("id").forGetter(GameProfile::getId), (App)ExtraCodecs.PLAYER_NAME.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)instance, GameProfile::new));
    public static final Codec<Climate.ParameterList<Holder<Biome>>> CLIMATE_SYSTEM = ExtraCodecs.nonEmptyList((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Climate.ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.CODEC.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(Climate.ParameterList::new, Climate.ParameterList::values);
    public static final StreamCodec<ByteBuf, Pair<BoundingBox, Boolean>> BOX_AND_FLAG_STREAM_CODEC = new StreamCodec<ByteBuf, Pair<BoundingBox, Boolean>>(){

        public Pair<BoundingBox, Boolean> decode(ByteBuf buf) {
            BoundingBox box = (BoundingBox)BOX_STREAM_CODEC.decode((Object)buf);
            boolean flag = buf.readBoolean();
            return Pair.of((Object)box, (Object)flag);
        }

        public void encode(ByteBuf buf, Pair<BoundingBox, Boolean> boxAndFlag) {
            BOX_STREAM_CODEC.encode((Object)buf, (Object)((BoundingBox)boxAndFlag.getFirst()));
            buf.writeBoolean(((Boolean)boxAndFlag.getSecond()).booleanValue());
        }
    };

    public static <T> Codec<Float2ObjectSortedMap<T>> floatTreeCodec(Codec<T> elementCodec) {
        return Codec.compoundList(FLOAT_STRING, elementCodec).xmap(floatEList -> (Float2ObjectSortedMap)floatEList.stream().collect(Float2ObjectAVLTreeMap::new, (map, pair) -> map.put((Float)pair.getFirst(), pair.getSecond()), AbstractFloat2ObjectMap::putAll), map -> map.entrySet().stream().map(entry -> new Pair((Object)((Float)entry.getKey()), entry.getValue())).toList());
    }

    public static <T> Codec<Double2ObjectSortedMap<T>> doubleTreeCodec(Codec<T> elementCodec) {
        return Codec.compoundList(DOUBLE_STRING, elementCodec).xmap(floatEList -> (Double2ObjectSortedMap)floatEList.stream().collect(Double2ObjectAVLTreeMap::new, (map, pair) -> map.put((Double)pair.getFirst(), pair.getSecond()), AbstractDouble2ObjectMap::putAll), map -> map.entrySet().stream().map(entry -> new Pair((Object)((Double)entry.getKey()), entry.getValue())).toList());
    }

    public static <T> StreamCodec<ByteBuf, List<T>> listOf(final StreamCodec<ByteBuf, T> elementCodec) {
        return new StreamCodec<ByteBuf, List<T>>(){

            public List<T> decode(ByteBuf buf) {
                int size = buf.readInt();
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(elementCodec.decode((Object)buf));
                }
                return list;
            }

            public void encode(ByteBuf buf, List<T> list) {
                buf.writeInt(list.size());
                for (Object t : list) {
                    elementCodec.encode((Object)buf, t);
                }
            }
        };
    }

    private static DataResult<BlockPos> parseString2BlockPos(String string) {
        try {
            return Util.fixedSize((IntStream)Arrays.stream(string.split(" *, *")).mapToInt(Integer::parseInt), (int)3).map(arr -> new BlockPos(arr[0], arr[1], arr[2]));
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
    }

    private static DataResult<Float> parseString2Float(String string) {
        try {
            return DataResult.success((Object)Float.valueOf(string));
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
    }

    private static DataResult<Double> parseString2Double(String string) {
        try {
            return DataResult.success((Object)Double.valueOf(string));
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
    }

    public static <T> Codec<T> fromRegistry(Registry<T> registry) {
        return ResourceLocation.CODEC.xmap(arg_0 -> registry.get(arg_0), arg_0 -> registry.getKey(arg_0));
    }

    public static <E> DataResult<Pair<E, E>> arrayToPair(List<E> list) {
        return Util.fixedSize(list, (int)2).map(l -> Pair.of(l.get(0), l.get(1)));
    }

    private static DataResult<MapColor> validateMapColor(MapColor color) {
        return color.id <= 63 && MapColor.byId((int)color.id) != MapColor.NONE ? DataResult.success((Object)color) : DataResult.error(() -> "Provided MapColor is not a valid MapColor");
    }

    private Codecs() {
    }
}

