/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.entities;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import twilightforest.init.TFDataAttachments;

public class OminousFireDamageSource
extends DamageSource {
    public OminousFireDamageSource(DamageSource wrappedSource) {
        super(wrappedSource.typeHolder(), wrappedSource.getEntity(), wrappedSource.getDirectEntity(), wrappedSource.getSourcePosition());
    }

    public Component getLocalizedDeathMessage(LivingEntity living) {
        Zombie zombie;
        LivingEntity livingEntity = living.getKillCredit();
        if (livingEntity instanceof Zombie && (zombie = (Zombie)livingEntity).hasData(TFDataAttachments.ZOMBIFIED_PLAYER)) {
            Player player;
            if (living instanceof Player && (player = (Player)living).getGameProfile().getName().equals(((GameProfile)zombie.getData(TFDataAttachments.ZOMBIFIED_PLAYER)).getName())) {
                return Component.translatable((String)"death.attack.twilightforest.ominousFire.zombified_player.self", (Object[])new Object[]{living.getDisplayName()});
            }
            return Component.translatable((String)"death.attack.twilightforest.ominousFire.zombified_player", (Object[])new Object[]{living.getDisplayName(), ((GameProfile)zombie.getData(TFDataAttachments.ZOMBIFIED_PLAYER)).getName()});
        }
        return super.getLocalizedDeathMessage(living);
    }
}

