/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class BoxDensityFunction
implements DensityFunction.SimpleFunction {
    public static final MapCodec<BoxDensityFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("minX").forGetter(f -> f.minX), (App)Codec.INT.fieldOf("minY").forGetter(f -> f.minY), (App)Codec.INT.fieldOf("minZ").forGetter(f -> f.minZ), (App)Codec.INT.fieldOf("maxX").forGetter(f -> f.maxX), (App)Codec.INT.fieldOf("maxY").forGetter(f -> f.maxY), (App)Codec.INT.fieldOf("maxZ").forGetter(f -> f.maxZ), (App)Codec.DOUBLE.fieldOf("minValue").forGetter(f -> f.minValue), (App)Codec.DOUBLE.fieldOf("maxValue").forGetter(f -> f.maxValue), (App)TerrainAdjustment.CODEC.fieldOf("beardifier").forGetter(f -> f.terrainAdjustment)).apply((Applicative)inst, BoxDensityFunction::new));
    public static final KeyDispatchDataCodec<BoxDensityFunction> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final double minValue;
    private final double maxValue;
    private final TerrainAdjustment terrainAdjustment;

    public static DensityFunction combine(List<BoundingBox> boxes, int dYMin, int dYMax, TerrainAdjustment terrainAdjustment) {
        if (boxes.isEmpty()) {
            return DensityFunctions.constant((double)0.0);
        }
        BoxDensityFunction densityFunction = BoxDensityFunction.make(boxes.getFirst(), dYMin, dYMax, terrainAdjustment);
        for (int idx = 1; idx < boxes.size(); ++idx) {
            densityFunction = DensityFunctions.add((DensityFunction)BoxDensityFunction.make(boxes.get(idx), dYMin, dYMax, terrainAdjustment), (DensityFunction)densityFunction);
        }
        return densityFunction;
    }

    public static BoxDensityFunction make(BoundingBox box, int dYMin, int dYMax, TerrainAdjustment terrainAdjustment) {
        return new BoxDensityFunction(box.minX(), box.minY() + dYMin, box.minZ(), box.maxX(), box.maxY() + dYMax, box.maxZ(), -4.0, 4.0, terrainAdjustment);
    }

    public BoxDensityFunction(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double minValue, double maxValue, TerrainAdjustment terrainAdjustment) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.terrainAdjustment = terrainAdjustment;
    }

    public double compute(DensityFunction.FunctionContext context) {
        int blockX = context.blockX();
        int blockY = context.blockY();
        int blockZ = context.blockZ();
        int xDist = Math.max(0, Math.max(this.minX - blockX, blockX - this.maxX));
        int zDist = Math.max(0, Math.max(this.minZ - blockZ, blockZ - this.maxZ));
        int distAboveBottom = blockY - this.minY;
        int yDist = switch (this.terrainAdjustment) {
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN -> distAboveBottom;
            case TerrainAdjustment.BEARD_BOX, TerrainAdjustment.ENCAPSULATE -> Math.max(0, Math.max(this.minY - blockY, blockY - this.maxY));
            default -> 0;
        };
        double densityValue = switch (this.terrainAdjustment) {
            case TerrainAdjustment.BURY -> Beardifier.getBuryContribution((double)xDist, (double)((double)yDist * 0.5), (double)zDist);
            case TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> Beardifier.getBeardContribution((int)xDist, (int)yDist, (int)zDist, (int)distAboveBottom) * 0.8;
            case TerrainAdjustment.ENCAPSULATE -> Beardifier.getBuryContribution((double)((double)xDist * 0.5), (double)((double)yDist * 0.5), (double)((double)zDist * 0.5)) * 0.8;
            default -> 0.0;
        };
        return Mth.clamp((double)densityValue, (double)this.minValue, (double)this.maxValue);
    }

    public double minValue() {
        return this.minValue;
    }

    public double maxValue() {
        return this.maxValue;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return KEY_CODEC;
    }
}

