/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.util.features.FeatureLogic;

@ParametersAreNonnullByDefault
public class BigMushgloomFeature
extends AbstractHugeMushroomFeature {
    public BigMushgloomFeature(Codec<HugeMushroomFeatureConfiguration> config) {
        super(config);
    }

    protected int getTreeHeight(RandomSource rand) {
        return 2 + rand.nextInt(2);
    }

    protected int getTreeRadiusForHeight(int i, int i1, int foliageRadius, int treeHeight) {
        return treeHeight <= 2 ? 0 : foliageRadius;
    }

    protected void makeCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        int foliageRadius = featureConfiguration.foliageRadius;
        int capHeight = random.nextBoolean() ? 1 : 2;
        for (int y = 0; y < capHeight; ++y) {
            for (int x = -foliageRadius; x <= foliageRadius; ++x) {
                for (int z = -foliageRadius; z <= foliageRadius; ++z) {
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, height + y, z);
                    if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.capProvider.getState(random, pos);
                    blockstate = FeatureLogic.getSphericalMushroomBlockState(blockstate, x, y, z, foliageRadius, capHeight);
                    this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }
}

