/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.RootPlacer;
import twilightforest.util.features.FeatureLogic;
import twilightforest.util.features.FeaturePlacers;
import twilightforest.util.iterators.VoxelBresenhamIterator;

public class TreeRootsDecorator
extends TreeDecorator {
    private static final SimpleStateProvider EMPTY = BlockStateProvider.simple((BlockState)Blocks.AIR.defaultBlockState());
    public static final MapCodec<TreeRootsDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)16).fieldOf("base_strand_count").forGetter(o -> o.strands), (App)Codec.intRange((int)0, (int)16).fieldOf("additional_random_strands").forGetter(o -> o.addExtraStrands), (App)Codec.intRange((int)0, (int)32).fieldOf("root_length").forGetter(o -> o.length), (App)Codec.INT.fieldOf("y_offset").forGetter(o -> o.yOffset), (App)BlockStateProvider.CODEC.optionalFieldOf("exposed_roots_provider").forGetter(o -> Optional.ofNullable(o.surfaceBlock != EMPTY ? o.surfaceBlock : null)), (App)BlockStateProvider.CODEC.fieldOf("ground_roots_provider").forGetter(o -> o.rootBlock), (App)Codec.INT.fieldOf("rootPenetrability").forGetter(o -> o.rootPenetrability)).apply((Applicative)instance, TreeRootsDecorator::new));
    private final int strands;
    private final int addExtraStrands;
    private final int length;
    private final int yOffset;
    private final BlockStateProvider surfaceBlock;
    private final BlockStateProvider rootBlock;
    private final boolean hasSurfaceRoots;
    private final int rootPenetrability;

    private TreeRootsDecorator(int count, int addExtraStrands, int length, int yOffset, Optional<BlockStateProvider> surfaceBlock, BlockStateProvider rootBlock, int rootPenetrability) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.yOffset = yOffset;
        this.rootBlock = rootBlock;
        this.rootPenetrability = rootPenetrability;
        this.hasSurfaceRoots = surfaceBlock.isPresent();
        this.surfaceBlock = this.hasSurfaceRoots ? surfaceBlock.get() : EMPTY;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, BlockStateProvider rootBlock, int rootPenetrability) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.yOffset = 0;
        this.rootBlock = rootBlock;
        this.rootPenetrability = rootPenetrability;
        this.hasSurfaceRoots = false;
        this.surfaceBlock = EMPTY;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, int yOffset, BlockStateProvider surfaceBlock, BlockStateProvider rootBlock, int rootPenetrability) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.yOffset = yOffset;
        this.rootBlock = rootBlock;
        this.rootPenetrability = rootPenetrability;
        this.hasSurfaceRoots = true;
        this.surfaceBlock = surfaceBlock;
    }

    protected TreeDecoratorType<TreeRootsDecorator> type() {
        return (TreeDecoratorType)TFFeatureModifiers.TREE_ROOTS.get();
    }

    public void place(TreeDecorator.Context context) {
        if (context.logs().isEmpty()) {
            return;
        }
        int numBranches = this.strands + context.random().nextInt(this.addExtraStrands + 1);
        float offset = context.random().nextFloat();
        BlockPos startPos = ((BlockPos)context.logs().getFirst()).above(this.yOffset);
        if (this.hasSurfaceRoots) {
            for (int i = 0; i < numBranches; ++i) {
                BlockPos dest = FeatureLogic.translate(startPos.below(i + 2), this.length, 0.3 * (double)i + (double)offset, 0.8);
                FeaturePlacers.traceExposedRoot(context.level(), new RootPlacer(context.decorationSetter, this.rootPenetrability), context.random(), this.surfaceBlock, this.rootBlock, new VoxelBresenhamIterator(startPos.below(), dest));
            }
        } else {
            for (int i = 0; i < numBranches; ++i) {
                BlockPos dest = FeatureLogic.translate(startPos.below(i + 2), this.length, 0.3 * (double)i + (double)offset, 0.8);
                FeaturePlacers.traceRoot(context.level(), new RootPlacer(context.decorationSetter, this.rootPenetrability), context.random(), this.rootBlock, new VoxelBresenhamIterator(startPos.below(), dest));
            }
        }
    }
}

