/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.hollowtree;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.CritterBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.loot.TFLootTables;
import twilightforest.util.features.FeatureLogic;
import twilightforest.util.iterators.VoxelBresenhamIterator;

public abstract class HollowTreePiece
extends StructurePiece {
    static final int PLACE_FLAG = 19;
    public static final IntProvider DEFAULT_HEIGHT = UniformInt.of((int)32, (int)95);
    public static final IntProvider DEFAULT_RADIUS = UniformInt.of((int)1, (int)4);
    public static final BlockStateProvider DEFAULT_LOG = BlockStateProvider.simple((Block)((Block)TFBlocks.TWILIGHT_OAK_LOG.value()));
    public static final BlockStateProvider DEFAULT_WOOD = BlockStateProvider.simple((Block)((Block)TFBlocks.TWILIGHT_OAK_WOOD.value()));
    public static final BlockStateProvider DEFAULT_ROOT = BlockStateProvider.simple((Block)((Block)TFBlocks.ROOT_BLOCK.value()));
    public static final BlockStateProvider DEFAULT_LEAVES = BlockStateProvider.simple((Block)((Block)TFBlocks.TWILIGHT_OAK_LEAVES.value()));
    public static final BlockStateProvider DEFAULT_VINE = BlockStateProvider.simple((BlockState)Blocks.VINE.defaultBlockState());
    public static final BlockStateProvider DEFAULT_BUG = new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)((BlockState)((Block)TFBlocks.FIREFLY.value()).defaultBlockState().setValue((Property)CritterBlock.FACING, (Comparable)Direction.NORTH))).add((Object)((BlockState)((Block)TFBlocks.CICADA.value()).defaultBlockState().setValue((Property)CritterBlock.FACING, (Comparable)Direction.NORTH))));
    public static final BlockStateProvider DEFAULT_DUNGEON_AIR = BlockStateProvider.simple((Block)Blocks.AIR);
    public static final BlockStateProvider DEFAULT_DUNGEON_LOOT_BLOCK = BlockStateProvider.simple((BlockState)((BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.WEST)));
    public static final ResourceKey<LootTable> DEFAULT_DUNGEON_LOOT_TABLE = TFLootTables.TREE_CACHE;
    public static final Holder<EntityType<?>> DEFAULT_DUNGEON_MONSTER = TFEntities.SWARM_SPIDER;

    protected HollowTreePiece(StructurePieceType type, int genDepth, BoundingBox boundingBox) {
        super(type, genDepth, boundingBox);
    }

    public HollowTreePiece(StructurePieceType type, CompoundTag tag) {
        super(type, tag);
    }

    protected void placeProvidedBlock(WorldGenLevel world, BlockStateProvider possibleBlocks, RandomSource random, int sx, int sy, int sz, BoundingBox sbb, BlockPos origin, boolean forcedPlace, boolean leafHack) {
        BlockPos worldPos = this.getWorldPos(sx, sy, sz).immutable();
        if (!sbb.isInside((Vec3i)worldPos) || !forcedPlace && !FeatureLogic.treesReplaceable(world.getBlockState(worldPos))) {
            return;
        }
        BlockState state = possibleBlocks.getState(random, worldPos);
        if (state.hasProperty((Property)LeavesBlock.DISTANCE)) {
            int distance = leafHack ? 1 : Mth.clamp((int)origin.distManhattan((Vec3i)worldPos), (int)1, (int)7);
            world.setBlock(worldPos, (BlockState)state.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(distance)), 19);
        } else {
            world.setBlock(worldPos, state, 19);
        }
    }

    protected void fillColumnDown(WorldGenLevel pLevel, BlockStateProvider possibleBlocks, RandomSource random, int sx, int sy, int sz, BoundingBox pBox) {
        BlockPos.MutableBlockPos worldPos = this.getWorldPos(sx, sy, sz);
        if (!pBox.isInside((Vec3i)worldPos)) {
            return;
        }
        while (this.isReplaceableByStructures(pLevel.getBlockState((BlockPos)worldPos)) && worldPos.getY() > pLevel.getMinBuildHeight() + 1) {
            pLevel.setBlock((BlockPos)worldPos, possibleBlocks.getState(random, (BlockPos)worldPos), 19);
            worldPos.move(Direction.DOWN);
        }
    }

    protected void fillVineColumnDown(WorldGenLevel pLevel, BlockStateProvider possibleBlocks, RandomSource random, int sx, int sy, int sz, BoundingBox pBox, Direction direction) {
        BlockPos.MutableBlockPos worldPos = this.getWorldPos(sx, sy, sz);
        if (!pBox.isInside((Vec3i)worldPos)) {
            return;
        }
        while (this.nonFluidAndReplaceableByStructures(pLevel, worldPos) && worldPos.getY() > pLevel.getMinBuildHeight() + 1) {
            pLevel.setBlock((BlockPos)worldPos, (BlockState)possibleBlocks.getState(random, (BlockPos)worldPos).setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.valueOf(true)), 19);
            worldPos.move(Direction.DOWN);
        }
    }

    private boolean nonFluidAndReplaceableByStructures(WorldGenLevel pLevel, BlockPos.MutableBlockPos worldPos) {
        BlockState blockState = pLevel.getBlockState((BlockPos)worldPos);
        return blockState.getFluidState().isEmpty() && this.isReplaceableByStructures(blockState);
    }

    protected void drawBresehnam(WorldGenLevel level, BoundingBox writeableBounds, BlockPos startPos, BlockPos endPos, BlockStateProvider stateProvider, RandomSource random) {
        for (BlockPos worldPos : new VoxelBresenhamIterator(startPos, endPos)) {
            if (!writeableBounds.isInside((Vec3i)worldPos) || !FeatureLogic.treesReplaceable(level.getBlockState(worldPos))) continue;
            level.setBlock(worldPos, stateProvider.getState(random, worldPos), 19);
        }
    }

    protected void drawBlockBlob(WorldGenLevel world, BoundingBox sbb, int sx, int sy, int sz, int blobRadius, RandomSource random, BlockStateProvider stateProvider, boolean forcedPlace, boolean leafHack, boolean imperfect) {
        BlockPos origin = this.getWorldPos(sx, sy, sz).immutable();
        for (int dx = 0; dx <= blobRadius; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= blobRadius; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= blobRadius; dz = (int)((byte)(dz + 1))) {
                    byte dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > blobRadius) continue;
                    if (imperfect && dist == blobRadius) {
                        if (dx == dy && dy == dz) continue;
                        if (dx == dy && dz > dx && dx > 0 || dy == dz && dx > dy && dy > 0 || dz == dx && dy > dz && dz > 0) {
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy + dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy + dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy + dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy + dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy - dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy - dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) == 0) {
                                this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy - dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                            }
                            if (random.nextInt(2) != 0) continue;
                            this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy - dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                            continue;
                        }
                    }
                    this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy + dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy + dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy + dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy + dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy - dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx + dx, sy - dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy - dy, sz + dz, sbb, origin, forcedPlace, leafHack);
                    this.placeProvidedBlock(world, stateProvider, random, sx - dx, sy - dy, sz - dz, sbb, origin, forcedPlace, leafHack);
                }
            }
        }
    }

    @NotNull
    protected XoroshiroRandomSource getInterChunkDecoRNG(WorldGenLevel level) {
        return new XoroshiroRandomSource(level.getSeed() + (long)this.boundingBox.minX() * 321534781L ^ (long)this.boundingBox.minZ() * 756839L);
    }
}

