/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.WroughtIronFenceBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.entities.EntityUtil;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.UtilityPiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerBase;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingBeard;
import twilightforest.world.components.structures.util.SortablePiece;

public class LichPerimeterFence
extends TwilightJigsawPiece
implements PieceBeardifierModifier,
SortablePiece,
SpawnIndexProvider.Deny {
    @Nullable
    private final BlockPos leashPos;

    public LichPerimeterFence(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_PERIMETER_FENCE.value(), compoundTag, ctx, LichPerimeterFence.readSettings(compoundTag));
        this.placeSettings.addProcessor((StructureProcessor)JigsawReplacementProcessor.INSTANCE);
        this.placeSettings.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        this.leashPos = NbtUtils.readBlockPos((CompoundTag)compoundTag, (String)"leash_pos").orElse(null);
    }

    public LichPerimeterFence(StructureTemplateManager structureManager, JigsawPlaceContext jigsawContext, ResourceLocation templateId, RandomSource random) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_PERIMETER_FENCE.value(), 0, structureManager, templateId, jigsawContext);
        ObjectArrayList fenceBlocks;
        this.placeSettings.addProcessor((StructureProcessor)JigsawReplacementProcessor.INSTANCE);
        this.placeSettings.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        ObjectArrayList objectArrayList = fenceBlocks = (double)random.nextFloat() > 0.25 ? List.of() : this.template.filterBlocks(BlockPos.ZERO, this.placeSettings, (Block)TFBlocks.WROUGHT_IRON_FENCE.value(), true);
        if (!fenceBlocks.isEmpty()) {
            fenceBlocks.removeIf(info -> info.state().getValue(WroughtIronFenceBlock.POST) != WroughtIronFenceBlock.PostState.POST);
            Util.shuffle((List)fenceBlocks, (RandomSource)random);
        }
        this.leashPos = fenceBlocks.isEmpty() ? null : this.templatePosition.offset((Vec3i)((StructureTemplate.StructureBlockInfo)fenceBlocks.getFirst()).pos());
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.addAdditionalSaveData(ctx, structureTag);
        if (this.leashPos != null) {
            structureTag.put("leash_pos", NbtUtils.writeBlockPos((BlockPos)this.leashPos));
        }
    }

    @Override
    public void addChildren(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random) {
        super.addChildren(parent, pieceAccessor, random);
        Direction ladderDirection = this.getSourceJigsaw().orientation().top().getOpposite();
        BlockPos ladderColumnPos = this.getSourcePosition().relative(ladderDirection, 2).above(2);
        if (this.getSpareJigsaws().size() == 1 && ladderDirection.getAxis() != Direction.Axis.Y) {
            BoundingBox box = new BoundingBox(ladderColumnPos).inflatedBy(3);
            UtilityPiece treeClearance = new UtilityPiece(this.genDepth + 1, box, false);
            pieceAccessor.addPiece((StructurePiece)treeClearance);
            treeClearance.addChildren((StructurePiece)this, pieceAccessor, random);
        }
    }

    @Override
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @Override
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.BEARD_BOX;
    }

    @Override
    public int getGroundLevelDelta() {
        return 2;
    }

    public BlockPos bottomCenter() {
        return BoundingBoxUtils.bottomCenterOf(this.boundingBox);
    }

    @Override
    protected void processJigsaw(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, int jigsawIndex) {
    }

    public List<JigsawRecord> getLeftJunctions() {
        return this.matchSpareJigsaws(r -> "twilightforest:lich_tower/fence_edge_left".equals(r.name()));
    }

    public List<JigsawRecord> getRightJunctions() {
        return this.matchSpareJigsaws(r -> "twilightforest:lich_tower/fence_edge_right".equals(r.name()));
    }

    public static void generateFence(StructurePiece startingPiece, Structure.GenerationContext context, StructurePiecesBuilder structurePiecesBuilder, StructureTemplateManager structureManager, WorldgenRandom random, Direction direction, BlockPos fenceCenter) {
        StructurePiece structurePiece;
        LichPerimeterFence frontFence = LichPerimeterFence.startPerimeterFence(startingPiece, context, structurePiecesBuilder, structureManager, random, direction, fenceCenter);
        if (frontFence == null) {
            return;
        }
        Optional<StructurePiece> towerBase = structurePiecesBuilder.pieces.stream().filter(piece -> piece instanceof LichTowerBase).findFirst();
        if (towerBase.isEmpty() || !((structurePiece = towerBase.get()) instanceof LichTowerBase)) {
            return;
        }
        LichTowerBase base = (LichTowerBase)structurePiece;
        BlockPos baseBottomCenter = BoundingBoxUtils.bottomCenterOf(base.getBoundingBox());
        Direction sourceJigsawFront = base.getSourceJigsaw().orientation().front();
        BoundingBox leftDest = LichPerimeterFence.getClosestTrimOnGround(structurePiecesBuilder.pieces, baseBottomCenter.relative(sourceJigsawFront.getClockWise(), 64));
        BoundingBox rightDest = LichPerimeterFence.getClosestTrimOnGround(structurePiecesBuilder.pieces, baseBottomCenter.relative(sourceJigsawFront.getCounterClockWise(), 64));
        if (leftDest == null || rightDest == null) {
            return;
        }
        LichPerimeterFence.generatePerimeter(frontFence, structureManager, structurePiecesBuilder, random, context, leftDest.inflatedBy(-1), rightDest.inflatedBy(-1));
    }

    @Nullable
    private static BoundingBox getClosestTrimOnGround(List<StructurePiece> pieces, BlockPos pos) {
        LichTowerWingBeard closestPiece = null;
        float minDistSq = Float.MAX_VALUE;
        for (StructurePiece piece : pieces) {
            BlockPos bottomCenter;
            float distSqr;
            LichTowerWingBeard beard;
            if (!(piece instanceof LichTowerWingBeard) || !(beard = (LichTowerWingBeard)piece).isTrim() || !((distSqr = LichPerimeterFence.horizontalDist(bottomCenter = BoundingBoxUtils.bottomCenterOf(piece.getBoundingBox()), pos)) < minDistSq)) continue;
            minDistSq = distSqr;
            closestPiece = beard;
        }
        return closestPiece == null ? null : closestPiece.getBoundingBox();
    }

    private static float horizontalDist(BlockPos first, BlockPos second) {
        int dX = second.getX() - first.getX();
        int dZ = second.getZ() - first.getZ();
        return Mth.sqrt((float)(dX * dX + dZ * dZ));
    }

    @Nullable
    public static LichPerimeterFence startPerimeterFence(StructurePiece vestibule, Structure.GenerationContext context, StructurePiecesBuilder structurePiecesBuilder, StructureTemplateManager structureManager, WorldgenRandom random, Direction direction, BlockPos fenceCenter) {
        FrontAndTop orientation = FrontAndTop.fromFrontAndTop((Direction)Direction.UP, (Direction)direction);
        int baseY = fenceCenter.getY();
        JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(fenceCenter.atY(baseY - 2), BlockPos.ZERO, orientation, structureManager, TwilightForestMod.prefix("lich_tower/outer_fence_7"), "twilightforest:lich_tower/fence_source", (RandomSource)random);
        if (placeableJunction == null) {
            return null;
        }
        LichPerimeterFence fenceStarter = new LichPerimeterFence(structureManager, placeableJunction, TwilightForestMod.prefix("lich_tower/outer_fence_7"), (RandomSource)random);
        structurePiecesBuilder.addPiece((StructurePiece)fenceStarter);
        fenceStarter.addChildren(vestibule, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)random);
        return fenceStarter;
    }

    public static void generatePerimeter(LichPerimeterFence frontFence, StructureTemplateManager structureManager, StructurePiecesBuilder structurePiecesBuilder, WorldgenRandom random, Structure.GenerationContext context, BoundingBox leftDest, BoundingBox rightDest) {
        ResourceLocation fullFenceId = TwilightForestMod.prefix("lich_tower/outer_fence_7");
        LichPerimeterFence.generateSidedPerimeter(frontFence, structureManager, structurePiecesBuilder, random, context, fullFenceId, leftDest, LichPerimeterFence::getLeftJunctions, Rotation.CLOCKWISE_90);
        LichPerimeterFence.generateSidedPerimeter(frontFence, structureManager, structurePiecesBuilder, random, context, fullFenceId, rightDest, LichPerimeterFence::getRightJunctions, Rotation.COUNTERCLOCKWISE_90);
    }

    private static void generateSidedPerimeter(LichPerimeterFence frontFence, StructureTemplateManager structureManager, StructurePiecesBuilder structurePiecesBuilder, WorldgenRandom random, Structure.GenerationContext context, ResourceLocation fullFenceId, BoundingBox destination, Function<LichPerimeterFence, List<JigsawRecord>> junctionGetter, Rotation rotation) {
        int stepSize;
        LichPerimeterFence fence = LichPerimeterFence.nextFence(frontFence, structureManager, structurePiecesBuilder, random, junctionGetter.apply(frontFence), Rotation.NONE, context, fullFenceId, destination);
        if (fence == null) {
            return;
        }
        fence = LichPerimeterFence.generateUntilNearDest(structureManager, structurePiecesBuilder, random, context, destination, 4, fence, rotation, junctionGetter, fullFenceId);
        List<JigsawRecord> fenceJunctions = junctionGetter.apply(fence);
        if (fence == null || fenceJunctions.isEmpty()) {
            return;
        }
        JigsawRecord first = fenceJunctions.getFirst();
        BlockPos fencePostPos = fence.templatePosition.offset((Vec3i)first.pos());
        for (int distance = Math.min(BoundingBoxUtils.greatestAxalDistance(destination, fencePostPos) + 1, 32); distance > 2; distance -= stepSize) {
            stepSize = Math.min(distance, 7);
            if ((fence = LichPerimeterFence.nextFence(fence, structureManager, structurePiecesBuilder, random, junctionGetter.apply(fence), rotation, context, TwilightForestMod.prefix("lich_tower/outer_fence_" + stepSize), destination)) == null) {
                return;
            }
            rotation = Rotation.NONE;
        }
    }

    @Nullable
    private static LichPerimeterFence generateUntilNearDest(StructureTemplateManager structureManager, StructurePiecesBuilder structurePiecesBuilder, WorldgenRandom random, Structure.GenerationContext context, BoundingBox destBox, int turnAtIndex, LichPerimeterFence fence, Rotation turn, Function<LichPerimeterFence, List<JigsawRecord>> junctionGetter, ResourceLocation templateId) {
        int infoldedPieces = 0;
        int counterRotatedPieces = 0;
        boolean foldNext = false;
        int foldAt = random.nextInt(turnAtIndex - 1);
        int maximumPosts = 16;
        for (int idx = 0; idx < maximumPosts; ++idx) {
            Rotation nextTurn;
            List<JigsawRecord> junctions;
            boolean marchTowardsDest;
            boolean makeTurn = idx == turnAtIndex;
            boolean bl = marchTowardsDest = idx > turnAtIndex;
            if (fence == null || (junctions = junctionGetter.apply(fence)).isEmpty()) break;
            if (marchTowardsDest) {
                JigsawRecord first = junctions.getFirst();
                BlockPos checkPos = fence.templatePosition.offset((Vec3i)first.pos());
                BlockPos destPos = BoundingBoxUtils.clampedInside(destBox, checkPos);
                BlockPos directionOffset = destPos.subtract((Vec3i)checkPos);
                Vec3i targetDirecton = turn.rotate(first.orientation().top()).getNormal();
                if (directionOffset.getX() * targetDirecton.getX() + directionOffset.getZ() * targetDirecton.getZ() == 0) {
                    break;
                }
            } else if (idx == foldAt) {
                infoldedPieces = random.nextIntBetweenInclusive(1, idx + 1);
                counterRotatedPieces = turnAtIndex - infoldedPieces;
                turnAtIndex += infoldedPieces;
                foldNext = true;
            }
            if (infoldedPieces > 0) {
                nextTurn = foldNext ? turn : Rotation.NONE;
                foldNext = false;
                fence = LichPerimeterFence.nextFence(fence, structureManager, structurePiecesBuilder, random, junctions, nextTurn, context, templateId, destBox);
                if (--infoldedPieces != 0) continue;
                foldNext = true;
                continue;
            }
            if (counterRotatedPieces > 0) {
                nextTurn = foldNext ? Rotation.CLOCKWISE_180.getRotated(turn) : (makeTurn ? turn : Rotation.NONE);
                foldNext = false;
                fence = LichPerimeterFence.nextFence(fence, structureManager, structurePiecesBuilder, random, junctions, nextTurn, context, templateId, destBox);
                --counterRotatedPieces;
                continue;
            }
            nextTurn = makeTurn ? turn : Rotation.NONE;
            fence = LichPerimeterFence.nextFence(fence, structureManager, structurePiecesBuilder, random, junctions, nextTurn, context, templateId, destBox);
        }
        return fence;
    }

    @Nullable
    public static LichPerimeterFence nextFence(LichPerimeterFence parentFence, StructureTemplateManager structureManager, StructurePiecesBuilder structurePiecesBuilder, WorldgenRandom random, List<JigsawRecord> junctions, Rotation rotation, Structure.GenerationContext context, ResourceLocation templateId, BoundingBox destination) {
        if (junctions.isEmpty()) {
            return null;
        }
        JigsawRecord junction = junctions.getFirst();
        FrontAndTop orientation = junction.orientation();
        FrontAndTop connectOrientation = FrontAndTop.fromFrontAndTop((Direction)orientation.front().getOpposite(), (Direction)rotation.rotate(orientation.top()));
        BlockPos postPos = parentFence.templatePosition.offset((Vec3i)junction.pos());
        int horizontalAxalDistance = BoundingBoxUtils.horizontalManhattanDistance(destination, postPos);
        int dY = horizontalAxalDistance <= 20 ? Mth.clamp((int)(parentFence.templatePosition().getY() - 1), (int)(destination.minY() + 2), (int)(destination.maxY() - 2)) - 1 - parentFence.templatePosition().getY() : 0;
        BlockPos parentPos = parentFence.templatePosition().above(Mth.sign((double)dY) - 1);
        JigsawPlaceContext placeContext = JigsawPlaceContext.pickPlaceableJunction(parentPos, junction.pos(), connectOrientation, structureManager, templateId, junction.target(), (RandomSource)random);
        if (placeContext == null) {
            return null;
        }
        LichPerimeterFence nextFence = new LichPerimeterFence(structureManager, placeContext, templateId, (RandomSource)random);
        structurePiecesBuilder.addPiece((StructurePiece)nextFence);
        nextFence.addChildren((StructurePiece)parentFence, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)random);
        return nextFence;
    }

    @Override
    public int getSortKey() {
        return this.boundingBox.maxY();
    }

    public Stream<BlockPos> fencePostPositions() {
        return Streams.concat((Stream[])new Stream[]{this.getLeftJunctions().stream(), this.getRightJunctions().stream()}).map(r -> this.templatePosition.offset((Vec3i)r.pos()));
    }

    @Override
    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos structureCenterPos) {
        super.postProcess(level, structureManager, chunkGen, random, chunkBounds, chunkPos, structureCenterPos);
        this.generateBoundZombie(level, chunkBounds);
        this.generateEscapeLadder(level, chunkBounds);
    }

    private void generateBoundZombie(WorldGenLevel level, BoundingBox chunkBounds) {
        Direction fenceFacing = this.getSourceJigsaw().orientation().top();
        if (this.leashPos == null || !chunkBounds.isInside((Vec3i)this.leashPos)) {
            return;
        }
        BlockPos zombiePos = this.leashPos.relative(fenceFacing, 1);
        if (!chunkBounds.isInside((Vec3i)zombiePos)) {
            return;
        }
        LeashFenceKnotEntity knot = (LeashFenceKnotEntity)EntityUtil.createEntityIgnoreException((ServerLevelAccessor)level, EntityType.LEASH_KNOT);
        Zombie boundedEntity = (Zombie)EntityUtil.createEntityIgnoreException((ServerLevelAccessor)level, EntityType.ZOMBIE);
        if (knot == null || boundedEntity == null) {
            return;
        }
        knot.moveTo((double)this.leashPos.getX() + 0.5, (double)this.leashPos.getY(), (double)this.leashPos.getZ() + 0.5);
        boundedEntity.setPersistenceRequired();
        boundedEntity.setLeashedTo((Entity)knot, false);
        boundedEntity.moveTo((double)zombiePos.getX() + 0.5, (double)(zombiePos.getY() - 1), (double)zombiePos.getZ() + 0.5);
        boundedEntity.setData(TFDataAttachments.LEASH_PATHFINDER_OVERRIDE, (Object)Unit.INSTANCE);
        level.addFreshEntity((Entity)boundedEntity);
    }

    private void generateEscapeLadder(WorldGenLevel level, BoundingBox chunkBounds) {
        Direction ladderDirection = this.getSourceJigsaw().orientation().top().getOpposite();
        BlockPos ladderColumnPos = this.getSourcePosition().relative(ladderDirection);
        if (!chunkBounds.isInside((Vec3i)ladderColumnPos) || this.getSpareJigsaws().size() != 1 || ladderDirection.getAxis() == Direction.Axis.Y) {
            return;
        }
        BlockState ladderState = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)ladderDirection);
        for (BlockPos ladderPos : BlockPos.betweenClosed((BlockPos)ladderColumnPos.above(), (BlockPos)ladderColumnPos.above(4))) {
            level.setBlock(ladderPos, ladderState, 3);
        }
    }
}

