/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;

public class AvoidLandmarkGridPlacement
extends RandomSpreadStructurePlacement {
    public static final MapCodec<AvoidLandmarkGridPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> AvoidLandmarkGridPlacement.placementCodec((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType))).apply((Applicative)instance, AvoidLandmarkGridPlacement::new)).validate(AvoidLandmarkGridPlacement::validate);

    private static DataResult<AvoidLandmarkGridPlacement> validate(AvoidLandmarkGridPlacement placement) {
        return placement.spacing() <= placement.separation() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
    }

    public AvoidLandmarkGridPlacement(int spacing, int separation, RandomSpreadType spreadType, int salt) {
        super(spacing, separation, spreadType, salt);
    }

    public AvoidLandmarkGridPlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod reduction, float frequencyModifier, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, reduction, frequencyModifier, salt, exclusionZone, spacing, separation, spreadType);
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        ChunkPos chunkpos = this.getPotentialStructureChunk(state.getLevelSeed(), chunkX, chunkZ);
        if (chunkpos.x != chunkX || chunkpos.z != chunkZ) {
            return false;
        }
        BlockPos.MutableBlockPos featurePos = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ).mutable();
        featurePos.set(Math.abs(featurePos.getX() - chunkpos.getWorldPosition().getX()), 0, Math.abs(featurePos.getZ() - chunkpos.getWorldPosition().getZ()));
        int size = 80;
        return featurePos.getX() >= size || featurePos.getZ() >= size;
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)TFStructurePlacementTypes.AVOID_GRID_LANDMARK_PLACEMENT_TYPE.get();
    }
}

