/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import java.util.List;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import twilightforest.world.components.structures.util.ControlledSpawns;

public interface ConfigurableSpawns
extends ControlledSpawns {
    public ControlledSpawns.ControlledSpawningConfig getConfig();

    @Override
    default public List<MobSpawnSettings.SpawnerData> getCombinedMonsterSpawnableList() {
        return this.getConfig().combinedMonsterSpawnableCache();
    }

    @Override
    default public List<MobSpawnSettings.SpawnerData> getCombinedCreatureSpawnableList() {
        return this.getConfig().combinedCreatureSpawnableCache();
    }

    @Override
    default public List<MobSpawnSettings.SpawnerData> getSpawnableList(MobCategory creatureType) {
        return switch (creatureType) {
            case MobCategory.MONSTER -> this.getSpawnableMonsterList(0);
            case MobCategory.AMBIENT -> this.getConfig().ambientCreatureList();
            case MobCategory.WATER_CREATURE -> this.getConfig().waterCreatureList();
            default -> List.of();
        };
    }

    @Override
    default public List<MobSpawnSettings.SpawnerData> getSpawnableMonsterList(int index) {
        return this.getConfig().getForLabel("" + index);
    }
}

