/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.tools.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidUtils {
    public static float getRed(int color) {
        return (float)FastColor.ARGB32.red((int)color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)FastColor.ARGB32.green((int)color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)FastColor.ARGB32.blue((int)color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
    }

    public static void color(GuiGraphics guiGraphics, int color) {
        guiGraphics.setColor(FluidUtils.getRed(color), FluidUtils.getGreen(color), FluidUtils.getBlue(color), FluidUtils.getAlpha(color));
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(@NotNull FluidStack fluidStack) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = extensions.getStillTexture(fluidStack);
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
    }

    public static int getLiquidColorWithBiome(@NotNull FluidStack fluidStack, Level level, BlockPos pos) {
        if (level.isClientSide && fluidStack.getFluid().isSame((Fluid)Fluids.WATER)) {
            return BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) | 0xFF000000;
        }
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int getLiquidColorWithBiome(@NotNull FluidStack fluid, @NotNull BlockEntity blockEntity) {
        return FluidUtils.getLiquidColorWithBiome(fluid, blockEntity.getLevel(), blockEntity.getBlockPos());
    }

    public static int getFluidScaled(int pixels, FluidStack fluid, int maxLiquidAmount) {
        if (maxLiquidAmount == 0) {
            return pixels;
        }
        long currentLiquidAmount = fluid.getAmount();
        long x = currentLiquidAmount * (long)pixels / (long)maxLiquidAmount;
        return pixels - (int)x;
    }
}

