/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="solcarrot")
public final class TooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!SOLCarrotConfig.isFoodTooltipEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack food = event.getItemStack();
        if (food.getFoodProperties((LivingEntity)player) == null) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        boolean hasBeenEaten = foodList.hasEaten(food);
        boolean isAllowed = SOLCarrotConfig.isAllowed(food.getItem());
        boolean isHearty = SOLCarrotConfig.isHearty(food);
        List tooltip = event.getToolTip();
        if (!isAllowed) {
            if (hasBeenEaten) {
                tooltip.add(TooltipHandler.localizedTooltip("disabled.eaten", ChatFormatting.DARK_RED));
            }
            String key = SOLCarrotConfig.hasWhitelist() ? "whitelist" : "blacklist";
            tooltip.add(TooltipHandler.localizedTooltip("disabled." + key, ChatFormatting.DARK_GRAY));
        } else if (isHearty) {
            if (hasBeenEaten) {
                tooltip.add(TooltipHandler.localizedTooltip("hearty.eaten", ChatFormatting.DARK_GREEN));
            } else {
                tooltip.add(TooltipHandler.localizedTooltip("hearty.not_eaten", ChatFormatting.DARK_AQUA));
            }
        } else {
            if (hasBeenEaten) {
                tooltip.add(TooltipHandler.localizedTooltip("cheap.eaten", ChatFormatting.DARK_RED));
            }
            tooltip.add(TooltipHandler.localizedTooltip("cheap", ChatFormatting.DARK_GRAY));
        }
    }

    private static MutableComponent localizedTooltip(String path, ChatFormatting color) {
        return Localization.localizedComponent("tooltip", path, new Object[0]).withStyle(color);
    }

    private TooltipHandler() {
    }
}

