/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.blockentityrenders.baseber;

import com.direwolf20.justdirethings.client.renderers.DireModelBlockRenderer;
import com.direwolf20.justdirethings.client.renderers.DireVertexConsumer;
import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.common.blockentities.basebe.GooBlockBE_Base;
import com.direwolf20.justdirethings.common.blocks.gooblocks.GooBlock_Base;
import com.direwolf20.justdirethings.common.blocks.gooblocks.GooPatternBlock;
import com.direwolf20.justdirethings.datagen.JustDireItemTags;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class GooBlockRender_Base<T extends GooBlockBE_Base>
implements BlockEntityRenderer<T> {
    private static final float percentageDivisor = 100.0f / (float)GooPatternBlock.GOOSTAGE.getPossibleValues().size();
    private ItemStack cachedItemStack = ItemStack.EMPTY;
    private int currentItemIndex = 0;
    private long lastChangeTime = 0L;

    public GooBlockRender_Base(BlockEntityRendererProvider.Context p_173636_) {
    }

    public void render(T blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        BlockState blockState = blockentity.getBlockState();
        if (!((Boolean)blockState.getValue((Property)GooBlock_Base.ALIVE)).booleanValue()) {
            this.renderFloatingItem(blockentity, matrixStackIn, bufferIn, partialTicks, combinedLightsIn);
        }
        for (Direction direction : Direction.values()) {
            int remainingTicks = ((GooBlockBE_Base)((Object)blockentity)).getRemainingTimeFor(direction);
            if (remainingTicks <= 0) continue;
            int maxTicks = ((GooBlockBE_Base)((Object)blockentity)).getCraftingDuration(direction);
            this.renderTextures(direction, blockentity.getLevel(), blockentity.getBlockPos(), matrixStackIn, bufferIn, combinedOverlayIn, remainingTicks, maxTicks, blockentity.getBlockState(), (GooBlockBE_Base)((Object)blockentity));
        }
    }

    private ItemStack getNextItemFromTag(int tier) {
        TagKey<Item> tag;
        switch (tier) {
            case 1: {
                TagKey<Item> tagKey = JustDireItemTags.GOO_REVIVE_TIER_1;
                break;
            }
            case 2: {
                TagKey<Item> tagKey = JustDireItemTags.GOO_REVIVE_TIER_2;
                break;
            }
            case 3: {
                TagKey<Item> tagKey = JustDireItemTags.GOO_REVIVE_TIER_3;
                break;
            }
            case 4: {
                TagKey<Item> tagKey = JustDireItemTags.GOO_REVIVE_TIER_4;
                break;
            }
            default: {
                TagKey<Item> tagKey = tag = null;
            }
        }
        if (tag == null) {
            return ItemStack.EMPTY;
        }
        List items = BuiltInRegistries.ITEM.getTag(tag).stream().flatMap(h -> h.stream()).toList();
        if (items.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack nextItem = new ItemStack((ItemLike)((Holder)items.get(this.currentItemIndex)).value());
        this.currentItemIndex = (this.currentItemIndex + 1) % items.size();
        return nextItem;
    }

    private void renderFloatingItem(T blockentity, PoseStack matrixStackIn, MultiBufferSource bufferIn, float partialTicks, int combinedLightsIn) {
        long currentTime = System.currentTimeMillis();
        long cycleDuration = 3600L;
        long elapsedTime = (currentTime - this.lastChangeTime) % cycleDuration;
        float fadeFactor = (float)(0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)elapsedTime / (double)cycleDuration));
        if (elapsedTime < 50L && currentTime - this.lastChangeTime >= cycleDuration) {
            this.cachedItemStack = this.getNextItemFromTag(((GooBlockBE_Base)((Object)blockentity)).getTier());
            this.lastChangeTime = currentTime;
        }
        if (!this.cachedItemStack.isEmpty()) {
            for (Direction direction : Direction.values()) {
                matrixStackIn.pushPose();
                boolean isBlockItem = this.cachedItemStack.getItem() instanceof BlockItem;
                Vec3 itemPos = this.getOffsetPositionForSide(direction, isBlockItem);
                matrixStackIn.translate(itemPos.x, itemPos.y, itemPos.z);
                this.applyRotationForSide(matrixStackIn, direction);
                matrixStackIn.scale(0.6f, 0.6f, 0.6f);
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel bakedmodel = itemRenderer.getModel(this.cachedItemStack, blockentity.getLevel(), null, 0);
                this.renderTransparentItemStack(this.cachedItemStack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, combinedLightsIn, OverlayTexture.NO_OVERLAY, bakedmodel, fadeFactor);
                matrixStackIn.popPose();
            }
        }
    }

    public void renderTransparentItemStack(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel p_model, float fadeFactor) {
        if (!itemStack.isEmpty()) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            poseStack.pushPose();
            boolean flag = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED;
            boolean isBlockItem = itemStack.getItem() instanceof BlockItem;
            p_model = ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)p_model, (ItemDisplayContext)displayContext, (boolean)leftHand);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            if (!(p_model.isCustomRenderer() || itemStack.is(Items.TRIDENT) && !flag)) {
                BlockItem blockitem;
                Block block;
                Item item;
                boolean flag1 = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() && (item = itemStack.getItem()) instanceof BlockItem ? !((block = (blockitem = (BlockItem)item).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : p_model.getRenderPasses(itemStack, flag1)) {
                    for (RenderType rendertype : model.getRenderTypes(itemStack, flag1)) {
                        RenderType renderTypeToUse = isBlockItem ? RenderType.translucent() : rendertype;
                        VertexConsumer originalVertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderTypeToUse, (boolean)true, (boolean)itemStack.hasFoil());
                        DireVertexConsumer vertexConsumer = new DireVertexConsumer(originalVertexconsumer, fadeFactor);
                        itemRenderer.renderModelLists(model, itemStack, combinedLight, combinedOverlay, poseStack, (VertexConsumer)vertexConsumer);
                    }
                }
            } else {
                IClientItemExtensions.of((ItemStack)itemStack).getCustomRenderer().renderByItem(itemStack, displayContext, poseStack, buffer, combinedLight, combinedOverlay);
            }
            poseStack.popPose();
        }
    }

    private Vec3 getOffsetPositionForSide(Direction direction, boolean isBlockItem) {
        double offset = 0.025;
        double nudge = isBlockItem ? 0.1 : 0.05;
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> new Vec3(0.5, 1.0 + offset, 0.5 - nudge);
            case Direction.DOWN -> new Vec3(0.5, 0.0 - offset, 0.5 + nudge);
            case Direction.NORTH -> new Vec3(0.5, 0.5 - nudge, 0.0 - offset);
            case Direction.SOUTH -> new Vec3(0.5, 0.5 - nudge, 1.0 + offset);
            case Direction.WEST -> new Vec3(0.0 - offset, 0.5 - nudge, 0.5);
            case Direction.EAST -> new Vec3(1.0 + offset, 0.5 - nudge, 0.5);
        };
    }

    private void applyRotationForSide(PoseStack matrixStackIn, Direction direction) {
        switch (direction) {
            case UP: {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                matrixStackIn.mulPose(Axis.XN.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(0.0f));
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
        }
    }

    public void renderTextures(Direction direction, Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedOverlayIn, int remainingTicks, int maxTicks, BlockState renderState, GooBlockBE_Base gooBlockBE_base) {
        BlockState patternState;
        float percentComplete = (1.0f - (float)remainingTicks / (float)maxTicks) * 100.0f;
        int tensDigit = (int)(percentComplete / percentageDivisor);
        if (tensDigit > 0) {
            patternState = (BlockState)((GooPatternBlock)((Object)Registration.GooPatternBlock.get())).defaultBlockState().setValue((Property)GooPatternBlock.GOOSTAGE, (Comparable)Integer.valueOf(tensDigit - 1));
            this.renderTexturePattern(direction, level, pos, matrixStackIn, bufferIn, combinedOverlayIn, 1.0f, patternState, renderState, gooBlockBE_base);
        }
        patternState = (BlockState)((GooPatternBlock)((Object)Registration.GooPatternBlock.get())).defaultBlockState().setValue((Property)GooPatternBlock.GOOSTAGE, (Comparable)Integer.valueOf(tensDigit));
        float startOfCurrentStage = (float)tensDigit * percentageDivisor;
        float percentagePart = percentComplete - startOfCurrentStage;
        float alpha = percentagePart / percentageDivisor;
        this.renderTexturePattern(direction, level, pos, matrixStackIn, bufferIn, combinedOverlayIn, alpha, patternState, renderState, gooBlockBE_base);
    }

    public void renderTexturePattern(Direction direction, Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedOverlayIn, float transparency, BlockState pattern, BlockState renderState, GooBlockBE_Base gooBlockBE_base) {
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        DireModelBlockRenderer modelBlockRenderer = new DireModelBlockRenderer(blockColors, direction);
        BlockPos renderAtPos = pos.relative(direction);
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        RandomSource randomSource = RandomSource.create();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = renderAtPos.mutable();
        ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
        matrixStackIn.pushPose();
        matrixStackIn.translate((float)direction.getNormal().getX(), (float)direction.getNormal().getY(), (float)direction.getNormal().getZ());
        float translateF = (float)gooBlockBE_base.getTier() / 2000.0f;
        matrixStackIn.translate(-translateF, -translateF, -translateF);
        float scaleF = (float)gooBlockBE_base.getTier() / 1000.0f;
        matrixStackIn.scale(1.0f + scaleF, 1.0f + scaleF, 1.0f + scaleF);
        matrixStackIn.translate(0.5, 0.5, 0.5);
        matrixStackIn.mulPose(direction.getRotation());
        matrixStackIn.translate(-0.5, -0.5, -0.5);
        VertexConsumer builder = bufferIn.getBuffer(OurRenderTypes.GooPattern);
        DireVertexConsumer chunksConsumer = new DireVertexConsumer(builder, 1.0f);
        BakedModel ibakedmodel = blockrendererdispatcher.getBlockModel(pattern);
        randomSource.setSeed(pattern.getSeed(renderAtPos));
        for (Direction renderSide : Direction.values()) {
            List list = ibakedmodel.getQuads(pattern, renderSide, randomSource, ModelData.EMPTY, null);
            if (list.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)renderAtPos, renderSide);
            modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, pattern, renderAtPos, matrixStackIn, (VertexConsumer)chunksConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
        }
        VertexConsumer builder2 = bufferIn.getBuffer(OurRenderTypes.RenderBlockBackface);
        DireVertexConsumer chunksConsumer2 = new DireVertexConsumer(builder2, transparency);
        BakedModel ibakedmodel2 = blockrendererdispatcher.getBlockModel(renderState);
        for (Direction renderSide : Direction.values()) {
            Direction newDirection = this.getDirection(direction, renderSide);
            modelBlockRenderer.setDirection(newDirection);
            List list2 = ibakedmodel2.getQuads(renderState, renderSide, randomSource, ModelData.EMPTY, null);
            if (list2.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)renderAtPos, renderSide);
            modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, renderAtPos, matrixStackIn, (VertexConsumer)chunksConsumer2, list2, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
        }
        matrixStackIn.popPose();
    }

    public Direction getDirection(Direction facing, Direction renderSide) {
        return switch (renderSide) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> facing;
            case Direction.DOWN -> facing.getOpposite();
            case Direction.WEST -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.WEST;
                }
                yield facing.getClockWise();
            }
            case Direction.EAST -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.EAST;
                }
                yield facing.getCounterClockWise();
            }
            case Direction.NORTH -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case UP: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.UP;
            }
            case Direction.SOUTH -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                    case UP: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.DOWN;
            }
        };
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return AABB.encapsulatingFullBlocks((BlockPos)blockEntity.getBlockPos().above(10).north(10).east(10), (BlockPos)blockEntity.getBlockPos().below(10).south(10).west(10));
    }
}

